/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import io.crate.action.FutureActionListener;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.elasticsearch.action.ActionListener;

public class CloseableChannel
implements Closeable {
    private final boolean isServerChannel;
    private final Channel channel;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private volatile long lastAccessedTime = TimeValue.nsecToMSec((long)System.nanoTime());

    public CloseableChannel(Channel channel, boolean isServerChannel) {
        this.isServerChannel = isServerChannel;
        this.channel = channel;
        this.channel.closeFuture().addListener(f -> {
            if (f.isSuccess()) {
                this.closeFuture.complete(null);
            } else {
                Throwable cause = f.cause();
                this.closeFuture.completeExceptionally(cause);
                if (cause instanceof Error) {
                    Exceptions.maybeDieOnAnotherThread((Throwable)cause);
                }
            }
        });
    }

    public ChannelFuture writeAndFlush(ByteBuf byteBuf) {
        return this.channel.writeAndFlush((Object)byteBuf);
    }

    public boolean isServerChannel() {
        return this.isServerChannel;
    }

    public void markAccessed(long relativeMillisTime) {
        this.lastAccessedTime = relativeMillisTime;
    }

    public long lastAccessedTime() {
        return this.lastAccessedTime;
    }

    public void addCloseListener(ActionListener<Void> listener) {
        this.closeFuture.whenComplete(listener);
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.channel.localAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.channel.remoteAddress();
    }

    @Override
    public void close() {
        this.channel.close();
    }

    public static void closeChannel(CloseableChannel channel, boolean blocking) {
        CloseableChannel.closeChannels(Collections.singletonList(channel), blocking);
    }

    public static void closeChannels(Collection<? extends CloseableChannel> channels, boolean blocking) {
        try {
            IOUtils.close(channels);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        if (blocking) {
            ArrayList<FutureActionListener<Void>> futures = new ArrayList<FutureActionListener<Void>>(channels.size());
            for (CloseableChannel closeableChannel : channels) {
                FutureActionListener<Void> closeFuture = new FutureActionListener<Void>();
                closeableChannel.addCloseListener(closeFuture);
                futures.add(closeFuture);
            }
            for (CompletableFuture completableFuture : futures) {
                try {
                    completableFuture.get();
                }
                catch (ExecutionException closeFuture) {
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public String toString() {
        return "Channel{isServer=" + this.isServerChannel + ", lastAccess=" + this.lastAccessedTime + ", netty=" + String.valueOf(this.channel) + "}";
    }
}

