/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util;

import io.crate.common.unit.TimeValue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class SingleObjectCache<T> {
    private volatile T cached;
    private Lock refreshLock = new ReentrantLock();
    private final long refreshIntervalNanos;
    protected long lastRefreshNanos = 0L;

    protected SingleObjectCache(TimeValue refreshInterval, T initialValue) {
        if (initialValue == null) {
            throw new IllegalArgumentException("initialValue must not be null");
        }
        this.refreshIntervalNanos = refreshInterval.nanos();
        this.cached = initialValue;
    }

    public T getOrRefresh() {
        if (this.needsRefresh() && this.refreshLock.tryLock()) {
            try {
                if (this.needsRefresh()) {
                    this.cached = this.refresh();
                    assert (this.cached != null);
                    this.lastRefreshNanos = System.nanoTime();
                }
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        assert (this.cached != null);
        return this.cached;
    }

    protected final T getNoRefresh() {
        return this.cached;
    }

    protected abstract T refresh();

    protected boolean needsRefresh() {
        if (this.refreshIntervalNanos == 0L) {
            return true;
        }
        long currentNanos = System.nanoTime();
        return currentNanos - this.lastRefreshNanos >= this.refreshIntervalNanos;
    }
}

