/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import io.crate.common.collections.Tuple;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Manifest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.Index;
import org.jetbrains.annotations.Nullable;

public class MetaStateService {
    private static final Logger LOGGER = LogManager.getLogger(MetaStateService.class);
    private final NodeEnvironment nodeEnv;
    private final NamedXContentRegistry namedXContentRegistry;
    private final NamedWriteableRegistry namedWriteableRegistry;
    protected MetadataStateFormat<Metadata> METADATA_FORMAT = Metadata.FORMAT;
    protected MetadataStateFormat<IndexMetadata> INDEX_METADATA_FORMAT = IndexMetadata.FORMAT;
    protected MetadataStateFormat<Manifest> MANIFEST_FORMAT = Manifest.FORMAT;

    public MetaStateService(NodeEnvironment nodeEnv, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry) {
        this.nodeEnv = nodeEnv;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.namedXContentRegistry = namedXContentRegistry;
    }

    public Tuple<Manifest, Metadata> loadFullState() throws IOException {
        Metadata.Builder metadataBuilder;
        Manifest manifest = this.MANIFEST_FORMAT.loadLatestState(LOGGER, this.namedWriteableRegistry, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        if (manifest == null) {
            return this.loadFullStateBWC();
        }
        if (manifest.isGlobalGenerationMissing()) {
            metadataBuilder = Metadata.builder();
        } else {
            Metadata globalMetadata = this.METADATA_FORMAT.loadGeneration(LOGGER, this.namedWriteableRegistry, this.namedXContentRegistry, manifest.getGlobalGeneration(), this.nodeEnv.nodeDataPaths());
            if (globalMetadata != null) {
                metadataBuilder = Metadata.builder(globalMetadata);
            } else {
                throw new IOException("failed to find global metadata [generation: " + manifest.getGlobalGeneration() + "]");
            }
        }
        for (Map.Entry<Index, Long> entry : manifest.getIndexGenerations().entrySet()) {
            String indexFolderName;
            Index index = entry.getKey();
            long generation = entry.getValue();
            IndexMetadata indexMetadata = this.INDEX_METADATA_FORMAT.loadGeneration(LOGGER, this.namedWriteableRegistry, this.namedXContentRegistry, generation, this.nodeEnv.resolveIndexFolder(indexFolderName = index.getUUID()));
            if (indexMetadata != null) {
                metadataBuilder.put(indexMetadata, false);
                continue;
            }
            throw new IOException("failed to find metadata for existing index " + index.getName() + " [location: " + indexFolderName + ", generation: " + generation + "]");
        }
        return new Tuple((Object)manifest, (Object)metadataBuilder.build());
    }

    private Tuple<Manifest, Metadata> loadFullStateBWC() throws IOException {
        HashMap<Index, Long> indices = new HashMap<Index, Long>();
        Tuple<Metadata, Long> metadataAndGeneration = this.METADATA_FORMAT.loadLatestStateWithGeneration(LOGGER, this.namedWriteableRegistry, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
        Metadata globalMetadata = (Metadata)metadataAndGeneration.v1();
        long globalStateGeneration = (Long)metadataAndGeneration.v2();
        Metadata.Builder metadataBuilder = globalMetadata != null ? Metadata.builder(globalMetadata) : Metadata.builder();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            Tuple<IndexMetadata, Long> indexMetadataAndGeneration = this.INDEX_METADATA_FORMAT.loadLatestStateWithGeneration(LOGGER, this.namedWriteableRegistry, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            IndexMetadata indexMetadata = (IndexMetadata)indexMetadataAndGeneration.v1();
            long generation = (Long)indexMetadataAndGeneration.v2();
            if (indexMetadata != null) {
                indices.put(indexMetadata.getIndex(), generation);
                metadataBuilder.put(indexMetadata, false);
                continue;
            }
            LOGGER.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        Manifest manifest = Manifest.unknownCurrentTermAndVersion(globalStateGeneration, indices);
        return new Tuple((Object)manifest, (Object)metadataBuilder.build());
    }

    @Nullable
    public IndexMetadata loadIndexState(Index index) throws IOException {
        return this.INDEX_METADATA_FORMAT.loadLatestState(LOGGER, this.namedWriteableRegistry, this.namedXContentRegistry, this.nodeEnv.indexPaths(index));
    }

    List<IndexMetadata> loadIndicesStates(Predicate<String> excludeIndexPathIdsPredicate) throws IOException {
        ArrayList<IndexMetadata> indexMetadataList = new ArrayList<IndexMetadata>();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders(excludeIndexPathIdsPredicate)) {
            assert (!excludeIndexPathIdsPredicate.test(indexFolderName)) : "unexpected folder " + indexFolderName + " which should have been excluded";
            IndexMetadata indexMetadata = this.INDEX_METADATA_FORMAT.loadLatestState(LOGGER, this.namedWriteableRegistry, this.namedXContentRegistry, this.nodeEnv.resolveIndexFolder(indexFolderName));
            if (indexMetadata != null) {
                String indexPathId = indexMetadata.getIndex().getUUID();
                if (indexFolderName.equals(indexPathId)) {
                    indexMetadataList.add(indexMetadata);
                    continue;
                }
                throw new IllegalStateException("[" + indexFolderName + "] invalid index folder name, rename to [" + indexPathId + "]");
            }
            LOGGER.debug("[{}] failed to find metadata for existing index location", (Object)indexFolderName);
        }
        return indexMetadataList;
    }

    Metadata loadGlobalState() throws IOException {
        return this.METADATA_FORMAT.loadLatestState(LOGGER, this.namedWriteableRegistry, this.namedXContentRegistry, this.nodeEnv.nodeDataPaths());
    }

    public void writeManifestAndCleanup(String reason, Manifest manifest) throws WriteStateException {
        LOGGER.trace("[_meta] writing state, reason [{}]", (Object)reason);
        try {
            long generation = this.MANIFEST_FORMAT.writeAndCleanup(manifest, this.nodeEnv.nodeDataPaths());
            LOGGER.trace("[_meta] state written (generation: {})", (Object)generation);
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(ex.isDirty(), "[_meta]: failed to write meta state", ex);
        }
    }

    public long writeIndex(String reason, IndexMetadata indexMetadata) throws WriteStateException {
        Index index = indexMetadata.getIndex();
        LOGGER.trace("[{}] writing state, reason [{}]", (Object)index, (Object)reason);
        try {
            long generation = this.INDEX_METADATA_FORMAT.write(indexMetadata, this.nodeEnv.indexPaths(indexMetadata.getIndex()));
            LOGGER.trace("[{}] state written", (Object)index);
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[" + String.valueOf(index) + "]: failed to write index state", ex);
        }
    }

    long writeGlobalState(String reason, Metadata metadata) throws WriteStateException {
        LOGGER.trace("[_global] writing state, reason [{}]", (Object)reason);
        try {
            long generation = this.METADATA_FORMAT.write(metadata, this.nodeEnv.nodeDataPaths());
            LOGGER.trace("[_global] state written");
            return generation;
        }
        catch (WriteStateException ex) {
            throw new WriteStateException(false, "[_global]: failed to write global state", ex);
        }
    }

    void cleanupGlobalState(long currentGeneration) {
        this.METADATA_FORMAT.cleanupOldFiles(currentGeneration, this.nodeEnv.nodeDataPaths());
    }

    public void cleanupIndex(Index index, long currentGeneration) {
        this.INDEX_METADATA_FORMAT.cleanupOldFiles(currentGeneration, this.nodeEnv.indexPaths(index));
    }

    public void unreferenceAll() throws IOException {
        this.MANIFEST_FORMAT.writeAndCleanup(Manifest.empty(), this.nodeEnv.nodeDataPaths());
        this.METADATA_FORMAT.cleanupOldFiles(Long.MAX_VALUE, this.nodeEnv.nodeDataPaths());
    }

    public void deleteAll() throws IOException {
        this.unreferenceAll();
        for (String indexFolderName : this.nodeEnv.availableIndexFolders()) {
            MetadataStateFormat.deleteMetaState(this.nodeEnv.resolveIndexFolder(indexFolderName));
        }
        this.MANIFEST_FORMAT.cleanupOldFiles(Long.MAX_VALUE, this.nodeEnv.nodeDataPaths());
    }
}

