/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.util.Comparator;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.settings.Settings;

public final class PriorityComparator
implements Comparator<ShardRouting> {
    private final RoutingAllocation allocation;

    public PriorityComparator(RoutingAllocation allocation) {
        this.allocation = allocation;
    }

    @Override
    public final int compare(ShardRouting o1, ShardRouting o2) {
        String o2Index;
        String o1Index = o1.getIndexName();
        if (!o1Index.equals(o2Index = o2.getIndexName())) {
            Metadata metadata = this.allocation.metadata();
            Settings settingsO1 = metadata.getIndexSafe(o1.index()).getSettings();
            Settings settingsO2 = metadata.getIndexSafe(o2.index()).getSettings();
            int cmp = Long.compare(PriorityComparator.timeCreated(settingsO2), PriorityComparator.timeCreated(settingsO1));
            if (cmp == 0) {
                return o2Index.compareTo(o1Index);
            }
        }
        return 0;
    }

    private static long timeCreated(Settings settings) {
        return settings.getAsLong("index.creation_date", -1L);
    }
}

