/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.util.Locale;
import java.util.StringJoiner;
import org.elasticsearch.index.search.MatchQuery;

public enum MultiMatchQueryType {
    BEST_FIELDS(MatchQuery.Type.BOOLEAN, 0.0f, "best_fields"),
    MOST_FIELDS(MatchQuery.Type.BOOLEAN, 1.0f, "most_fields"),
    CROSS_FIELDS(MatchQuery.Type.BOOLEAN, 0.0f, "cross_fields"),
    PHRASE(MatchQuery.Type.PHRASE, 0.0f, "phrase"),
    PHRASE_PREFIX(MatchQuery.Type.PHRASE_PREFIX, 0.0f, "phrase_prefix");

    private MatchQuery.Type matchQueryType;
    private final float tieBreaker;
    private final String fieldName;

    private MultiMatchQueryType(MatchQuery.Type matchQueryType, float tieBreaker, String fieldName) {
        this.matchQueryType = matchQueryType;
        this.tieBreaker = tieBreaker;
        this.fieldName = fieldName;
    }

    public float tieBreaker() {
        return this.tieBreaker;
    }

    public MatchQuery.Type matchQueryType() {
        return this.matchQueryType;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public static MultiMatchQueryType parse(String value) {
        for (MultiMatchQueryType t : MultiMatchQueryType.values()) {
            if (!t.fieldName().equalsIgnoreCase(value)) continue;
            return t;
        }
        StringJoiner matchTypes = new StringJoiner(", ");
        for (MultiMatchQueryType t : MultiMatchQueryType.values()) {
            matchTypes.add(t.fieldName());
        }
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unknown MATCH type \"%s\". Valid types are: %s", value, matchTypes));
    }
}

