/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;

public class ProcessStats
implements Writeable {
    private final long timestamp;
    private final long openFileDescriptors;
    private final long maxFileDescriptors;
    private final Cpu cpu;
    private final Mem mem;

    public ProcessStats(long timestamp, long openFileDescriptors, long maxFileDescriptors, Cpu cpu, Mem mem) {
        this.timestamp = timestamp;
        this.openFileDescriptors = openFileDescriptors;
        this.maxFileDescriptors = maxFileDescriptors;
        this.cpu = cpu;
        this.mem = mem;
    }

    public ProcessStats(StreamInput in) throws IOException {
        this.timestamp = in.readVLong();
        this.openFileDescriptors = in.readLong();
        this.maxFileDescriptors = in.readLong();
        this.cpu = in.readOptionalWriteable(Cpu::new);
        this.mem = in.readOptionalWriteable(Mem::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timestamp);
        out.writeLong(this.openFileDescriptors);
        out.writeLong(this.maxFileDescriptors);
        out.writeOptionalWriteable(this.cpu);
        out.writeOptionalWriteable(this.mem);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getOpenFileDescriptors() {
        return this.openFileDescriptors;
    }

    public long getMaxFileDescriptors() {
        return this.maxFileDescriptors;
    }

    public Cpu getCpu() {
        return this.cpu;
    }

    public Mem getMem() {
        return this.mem;
    }

    public static class Cpu
    implements Writeable {
        private final short percent;
        private final long total;

        public Cpu(short percent, long total) {
            this.percent = percent;
            this.total = total;
        }

        public Cpu(StreamInput in) throws IOException {
            this.percent = in.readShort();
            this.total = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeShort(this.percent);
            out.writeLong(this.total);
        }

        public short getPercent() {
            return this.percent;
        }

        public TimeValue getTotal() {
            return new TimeValue(this.total);
        }
    }

    public static class Mem
    implements Writeable {
        private final long totalVirtual;

        public Mem(long totalVirtual) {
            this.totalVirtual = totalVirtual;
        }

        public Mem(StreamInput in) throws IOException {
            this.totalVirtual = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.totalVirtual);
        }

        public ByteSizeValue getTotalVirtual() {
            return new ByteSizeValue(this.totalVirtual);
        }
    }
}

