/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;

public interface ActionPlugin {
    default public List<ActionHandler<? extends TransportRequest, ? extends TransportResponse>> getActions() {
        return Collections.emptyList();
    }

    default public Collection<String> getRestHeaders() {
        return Collections.emptyList();
    }

    public static final class ActionHandler<Request extends TransportRequest, Response extends TransportResponse> {
        private final ActionType<Response> action;
        private final Class<? extends TransportAction<Request, Response>> transportAction;
        private final Class<?>[] supportTransportActions;

        public ActionHandler(ActionType<Response> action, Class<? extends TransportAction<Request, Response>> transportAction, Class<?> ... supportTransportActions) {
            this.action = action;
            this.transportAction = transportAction;
            this.supportTransportActions = supportTransportActions;
        }

        public ActionType<Response> getAction() {
            return this.action;
        }

        public Class<? extends TransportAction<Request, Response>> getTransportAction() {
            return this.transportAction;
        }

        public Class<?>[] getSupportTransportActions() {
            return this.supportTransportActions;
        }

        public String toString() {
            StringBuilder b = new StringBuilder().append(this.action.name()).append(" is handled by ").append(this.transportAction.getName());
            if (this.supportTransportActions.length > 0) {
                b.append('[').append(Strings.arrayToCommaDelimitedString(this.supportTransportActions)).append(']');
            }
            return b.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != ActionHandler.class) {
                return false;
            }
            ActionHandler other = (ActionHandler)obj;
            return Objects.equals(this.action, other.action) && Objects.equals(this.transportAction, other.transportAction) && Objects.deepEquals(this.supportTransportActions, other.supportTransportActions);
        }

        public int hashCode() {
            return Objects.hash(this.action, this.transportAction, this.supportTransportActions);
        }
    }
}

