/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import io.crate.common.CheckedFunction;
import io.crate.server.xcontent.LoggingDeprecationHandler;
import io.crate.server.xcontent.XContentHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.ByteBuffersDataInput;
import org.apache.lucene.store.ByteBuffersIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.Version;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.store.ByteArrayIndexInput;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.CorruptStateException;

public final class ChecksumBlobStoreFormat<T extends Writeable> {
    public static final int XCONTENT_VERSION = 1;
    public static final int VERSION = 2;
    private static final int BUFFER_SIZE = 4096;
    private final String codec;
    private final String blobNameFormat;
    private final CheckedFunction<XContentParser, T, IOException> parse;
    private final Writeable.Reader<T> readFrom;

    public ChecksumBlobStoreFormat(String codec, String blobNameFormat, CheckedFunction<XContentParser, T, IOException> parse, Writeable.Reader<T> readFrom) {
        this.blobNameFormat = blobNameFormat;
        this.codec = codec;
        this.parse = parse;
        this.readFrom = readFrom;
    }

    public T read(BlobContainer blobContainer, String name, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry) throws IOException {
        String blobName = this.blobName(name);
        return this.deserialize(blobName, namedWriteableRegistry, namedXContentRegistry, Streams.readFully(blobContainer.readBlob(blobName)));
    }

    public String blobName(String name) {
        return String.format(Locale.ROOT, this.blobNameFormat, name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T deserialize(String blobName, NamedWriteableRegistry namedWritableRegistry, NamedXContentRegistry namedXContentRegistry, BytesReference bytes) throws IOException {
        String resourceDesc = "ChecksumBlobStoreFormat.readBlob(blob=\"" + blobName + "\")";
        try {
            Object indexInput = bytes.length() > 0 ? new ByteBuffersIndexInput(new ByteBuffersDataInput(Arrays.asList(BytesReference.toByteBuffers(bytes))), resourceDesc) : new ByteArrayIndexInput(resourceDesc, BytesRef.EMPTY_BYTES);
            CodecUtil.checksumEntireFile((IndexInput)indexInput);
            int stateVersion = CodecUtil.checkHeader((DataInput)indexInput, (String)this.codec, (int)1, (int)2);
            long filePointer = indexInput.getFilePointer();
            long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
            BytesReference slice = bytes.slice((int)filePointer, (int)contentSize);
            if (stateVersion == 1) {
                try (XContentParser parser = XContentHelper.createParser(namedXContentRegistry, LoggingDeprecationHandler.INSTANCE, slice, XContentType.SMILE);){
                    Writeable writeable = (Writeable)this.parse.apply((Object)parser);
                    return (T)writeable;
                }
            }
            StreamInput streamInput = CompressorFactory.COMPRESSOR.isCompressed(slice) ? new InputStreamStreamInput(CompressorFactory.COMPRESSOR.threadLocalInputStream(slice.streamInput())) : slice.streamInput();
            try (NamedWriteableAwareStreamInput in = new NamedWriteableAwareStreamInput(streamInput, namedWritableRegistry);){
                Writeable t;
                Version version = Version.readVersion(in);
                ((StreamInput)in).setVersion(version);
                Writeable writeable = t = (Writeable)this.readFrom.read(in);
                return (T)writeable;
            }
        }
        catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
            throw new CorruptStateException(ex);
        }
    }

    public void write(T obj, BlobContainer blobContainer, String name, boolean compress) throws IOException {
        String blobName = this.blobName(name);
        BytesReference bytes = this.serialize(obj, blobName, compress);
        blobContainer.writeBlob(blobName, bytes.streamInput(), bytes.length(), false);
    }

    public BytesReference serialize(T obj, String blobName, boolean compress) throws IOException {
        try (BytesStreamOutput resultStream = new BytesStreamOutput();){
            try (OutputStreamIndexOutput indexOutput = new OutputStreamIndexOutput("ChecksumBlobStoreFormat.writeBlob(blob=\"" + blobName + "\")", blobName, (OutputStream)resultStream, 4096);){
                CodecUtil.writeHeader((DataOutput)indexOutput, (String)this.codec, (int)2);
                IndexOutputOutputStream os = new IndexOutputOutputStream(this, (IndexOutput)indexOutput){

                    @Override
                    public void close() throws IOException {
                    }
                };
                os = compress ? CompressorFactory.COMPRESSOR.threadLocalOutputStream(os) : os;
                try (OutputStreamStreamOutput out = new OutputStreamStreamOutput(os);){
                    Version.writeVersion(Version.CURRENT, out);
                    obj.writeTo(out);
                }
                CodecUtil.writeFooter((IndexOutput)indexOutput);
            }
            BytesReference bytesReference = resultStream.bytes();
            return bytesReference;
        }
    }
}

