/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile.query;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Query;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.query.QueryProfileBreakdown;

public final class QueryProfiler {
    private final ArrayList<QueryProfileBreakdown> timings = new ArrayList(10);
    private final ArrayList<ArrayList<Integer>> tree;
    private final ArrayList<Query> elements;
    private final ArrayList<Integer> roots;
    private final Deque<Integer> stack = new ArrayDeque<Integer>(10);
    private int currentToken = 0;

    public QueryProfiler() {
        this.tree = new ArrayList(10);
        this.elements = new ArrayList(10);
        this.roots = new ArrayList(10);
    }

    public synchronized QueryProfileBreakdown getProfileBreakdown(Query query) {
        int token = this.currentToken++;
        boolean stackEmpty = this.stack.isEmpty();
        if (stackEmpty) {
            this.roots.add(token);
            this.stack.add(token);
            return this.addDependencyNode(query, token);
        }
        this.updateParent(token);
        ++this.currentToken;
        this.stack.add(token);
        return this.addDependencyNode(query, token);
    }

    private QueryProfileBreakdown addDependencyNode(Query element, int token) {
        this.tree.add(new ArrayList(5));
        this.elements.add(element);
        QueryProfileBreakdown queryTimings = this.createProfileBreakdown();
        this.timings.add(token, queryTimings);
        return queryTimings;
    }

    private QueryProfileBreakdown createProfileBreakdown() {
        return new QueryProfileBreakdown();
    }

    public void pollLast() {
        this.stack.pollLast();
    }

    public synchronized List<ProfileResult> getTree() {
        ArrayList<ProfileResult> results = new ArrayList<ProfileResult>(this.roots.size());
        for (Integer root : this.roots) {
            results.add(this.doGetTree(root));
        }
        return results;
    }

    private ProfileResult doGetTree(int token) {
        Query element = this.elements.get(token);
        QueryProfileBreakdown breakdown = this.timings.get(token);
        Map<String, Long> timings = breakdown.toTimingMap();
        List children = this.tree.get(token);
        List<ProfileResult> childrenProfileResults = Collections.emptyList();
        if (children != null) {
            childrenProfileResults = new ArrayList(children.size());
            for (Integer child : children) {
                ProfileResult childNode = this.doGetTree(child);
                childrenProfileResults.add(childNode);
            }
        }
        String type = this.getTypeFromElement(element);
        String description = this.getDescriptionFromElement(element);
        return new ProfileResult(type, description, timings, childrenProfileResults);
    }

    private String getTypeFromElement(Query query) {
        if (query.getClass().getSimpleName().isEmpty()) {
            return query.getClass().getSuperclass().getSimpleName();
        }
        return query.getClass().getSimpleName();
    }

    private String getDescriptionFromElement(Query query) {
        return query.toString();
    }

    private void updateParent(int childToken) {
        Integer parent = this.stack.peekLast();
        ArrayList<Integer> parentNode = this.tree.get(parent);
        parentNode.add(childToken);
        this.tree.set(parent, parentNode);
    }
}

