/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntSet;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.analyze.SnapshotSettings;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.PartitionAlreadyExistsException;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.execution.ddl.Templates;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateApplier;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RestoreInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataIndexUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RecoverySource;
import org.elasticsearch.cluster.routing.RoutingChangesObserver;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.plugins.MetadataUpgrader;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.RestoreInfo;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotRestoreException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class RestoreService
implements ClusterStateApplier {
    private static final Logger LOGGER = LogManager.getLogger(RestoreService.class);
    private static final Set<String> UNMODIFIABLE_SETTINGS = Set.of("index.number_of_shards", "index.version.created", "index.uuid", "index.creation_date", IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), "index.history.uuid");
    private static final Set<String> UNREMOVABLE_SETTINGS;
    private final ClusterService clusterService;
    private final RepositoriesService repositoriesService;
    private final AllocationService allocationService;
    private final MetadataCreateIndexService createIndexService;
    private final MetadataIndexUpgradeService metadataIndexUpgradeService;
    private final ClusterSettings clusterSettings;
    private final CleanRestoreStateTaskExecutor cleanRestoreStateTaskExecutor;
    private final ShardLimitValidator shardLimitValidator;
    private final MetadataUpgrader metadataUpgrader;

    public RestoreService(ClusterService clusterService, RepositoriesService repositoriesService, AllocationService allocationService, MetadataCreateIndexService createIndexService, MetadataIndexUpgradeService metadataIndexUpgradeService, MetadataUpgrader metadataUpgrader, ClusterSettings clusterSettings, ShardLimitValidator shardLimitValidator) {
        this.clusterService = clusterService;
        this.repositoriesService = repositoriesService;
        this.allocationService = allocationService;
        this.createIndexService = createIndexService;
        this.metadataIndexUpgradeService = metadataIndexUpgradeService;
        this.metadataUpgrader = metadataUpgrader;
        if (DiscoveryNode.isMasterEligibleNode(clusterService.getSettings())) {
            clusterService.addStateApplier(this);
        }
        this.clusterSettings = clusterSettings;
        this.cleanRestoreStateTaskExecutor = new CleanRestoreStateTaskExecutor(LOGGER);
        this.shardLimitValidator = shardLimitValidator;
    }

    public void restoreSnapshot(RestoreRequest request, @Nullable List<RestoreSnapshotRequest.TableOrPartition> tablesToRestore, ActionListener<RestoreCompletionResponse> listener) {
        Repository repository;
        String repositoryName = request.repositoryName;
        try {
            repository = this.repositoriesService.repository(repositoryName);
        }
        catch (Exception e) {
            LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)(request.repositoryName + ":" + request.snapshotName)), (Throwable)e);
            listener.onFailure(e);
            return;
        }
        ((CompletableFuture)repository.getRepositoryData().thenCompose(repositoryData -> {
            String snapshotName = request.snapshotName;
            Optional<SnapshotId> matchingSnapshotId = repositoryData.getSnapshotIds().stream().filter(s -> snapshotName.equals(s.getName())).findFirst();
            if (!matchingSnapshotId.isPresent()) {
                throw new SnapshotRestoreException(repositoryName, snapshotName, "snapshot does not exist");
            }
            SnapshotId snapshotId = matchingSnapshotId.get();
            return repository.getSnapshotInfo(snapshotId).thenCompose(snapshotInfo -> {
                Snapshot snapshot = new Snapshot(repositoryName, snapshotId);
                this.validateSnapshotRestorable(repositoryName, (SnapshotInfo)snapshotInfo);
                ArrayList<String> resolvedIndices = new ArrayList<String>();
                ArrayList<String> resolvedTemplates = new ArrayList<String>();
                RestoreService.resolveIndices(request, tablesToRestore, snapshotInfo.indices(), resolvedIndices, resolvedTemplates);
                boolean includeIndices = request.includeIndices();
                if (includeIndices && resolvedIndices.isEmpty() && tablesToRestore != null && tablesToRestore.size() > 0) {
                    includeIndices = false;
                }
                List indicesInSnapshot = includeIndices ? SnapshotUtils.filterIndices(snapshotInfo.indices(), resolvedIndices, request.indicesOptions()) : List.of();
                CompletableFuture<Metadata> futureGlobalMetadata = request.includeCustomMetadata() || request.includeGlobalSettings() || this.allTemplates(resolvedTemplates) || !resolvedTemplates.isEmpty() ? repository.getSnapshotGlobalMetadata(snapshotId) : CompletableFuture.completedFuture(Metadata.EMPTY_METADATA);
                return futureGlobalMetadata.thenCompose(globalMetadata -> {
                    Metadata.Builder metadataBuilder = Metadata.builder(globalMetadata);
                    List<IndexId> indexIdsInSnapshot = repositoryData.resolveIndices(indicesInSnapshot);
                    CompletableFuture<Collection<IndexMetadata>> futureSnapshotIndexMetadata = repository.getSnapshotIndexMetadata((RepositoryData)repositoryData, snapshotId, (Collection<IndexId>)indexIdsInSnapshot);
                    return futureSnapshotIndexMetadata.thenAccept(snapshotIndexMetadata -> {
                        for (IndexMetadata indexMetadata : snapshotIndexMetadata) {
                            metadataBuilder.put(indexMetadata, false);
                        }
                        Metadata metadata = metadataBuilder.build();
                        Map<String, String> indices = this.applyRenameToIndices(request, indicesInSnapshot);
                        RestoreSnapshotUpdateTask updateTask = new RestoreSnapshotUpdateTask((SnapshotInfo)snapshotInfo, snapshotId, (RepositoryData)repositoryData, snapshot, listener, request, indices, (List<String>)resolvedTemplates, metadata);
                        this.clusterService.submitStateUpdateTask("restore_snapshot[" + snapshotName + "]", updateTask);
                    });
                });
            });
        })).exceptionally(t -> {
            listener.onFailure(Exceptions.toException((Throwable)t));
            return null;
        });
    }

    private boolean allTemplates(Collection<String> resolvedTemplates) {
        return resolvedTemplates.size() == 1 && resolvedTemplates.contains("_all");
    }

    @VisibleForTesting
    static void resolveIndices(RestoreRequest request, @Nullable List<RestoreSnapshotRequest.TableOrPartition> tablesToRestore, List<String> availableIndices, List<String> resolvedIndices, List<String> resolvedTemplates) {
        if (tablesToRestore != null) {
            for (RestoreSnapshotRequest.TableOrPartition tableOrPartition : tablesToRestore) {
                String partitionTemplate = PartitionName.templateName(tableOrPartition.table().schema(), tableOrPartition.table().name());
                if (tableOrPartition.partitionIdent() != null) {
                    resolvedIndices.add(IndexName.encode(tableOrPartition.table().schema(), tableOrPartition.table().name(), tableOrPartition.partitionIdent()));
                    resolvedTemplates.add(partitionTemplate);
                    continue;
                }
                if (request.indicesOptions().ignoreUnavailable()) {
                    resolvedIndices.add(tableOrPartition.table().indexNameOrAlias());
                    resolvedIndices.add(partitionTemplate + "*");
                    resolvedTemplates.add(partitionTemplate);
                    continue;
                }
                String name = tableOrPartition.table().indexNameOrAlias();
                boolean found = false;
                for (String index : availableIndices) {
                    if (name.equals(index)) {
                        resolvedIndices.add(index);
                        found = true;
                        break;
                    }
                    if (!RestoreService.isIndexPartitionOfTable(index, tableOrPartition.table())) continue;
                    resolvedIndices.add(partitionTemplate + "*");
                    resolvedTemplates.add(partitionTemplate);
                    found = true;
                    break;
                }
                if (found) continue;
                resolvedTemplates.add(partitionTemplate);
            }
        } else {
            for (String index : request.indices()) {
                resolvedIndices.add(index);
            }
            for (String template : request.templates()) {
                resolvedTemplates.add(template);
            }
        }
        if (request.restoreAllTables() && (tablesToRestore == null || tablesToRestore.isEmpty())) {
            resolvedTemplates.add("_all");
        }
    }

    public static boolean isIndexPartitionOfTable(String index, RelationName relationName) {
        return IndexName.isPartitioned(index) && PartitionName.fromIndexOrTemplate(index).relationName().equals(relationName);
    }

    public static RestoreInProgress updateRestoreStateWithDeletedIndices(RestoreInProgress oldRestore, Set<Index> deletedIndices) {
        boolean changesMade = false;
        RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
        for (RestoreInProgress.Entry entry : oldRestore) {
            ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = null;
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                ShardId shardId = (ShardId)objectObjectCursor.key;
                if (!deletedIndices.contains(shardId.getIndex())) continue;
                changesMade = true;
                if (shardsBuilder == null) {
                    shardsBuilder = ImmutableOpenMap.builder(entry.shards());
                }
                shardsBuilder.put(shardId, new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "index was deleted"));
            }
            if (shardsBuilder != null) {
                ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), RestoreService.overallState(RestoreInProgress.State.STARTED, shards), entry.indices(), shards));
                continue;
            }
            builder.add(entry);
        }
        if (changesMade) {
            return builder.build();
        }
        return oldRestore;
    }

    public static RestoreInProgress.Entry restoreInProgress(ClusterState state, String restoreUUID) {
        return state.custom("restore", RestoreInProgress.EMPTY).get(restoreUUID);
    }

    private void cleanupRestoreState(ClusterChangedEvent event) {
        for (RestoreInProgress.Entry entry : event.state().custom("restore", RestoreInProgress.EMPTY)) {
            if (!entry.state().completed()) continue;
            assert (RestoreService.completed(entry.shards())) : "state says completed but restore entries are not";
            this.clusterService.submitStateUpdateTask("clean up snapshot restore state", new CleanRestoreStateTaskExecutor.Task(entry.uuid()), ClusterStateTaskConfig.build(Priority.URGENT), this.cleanRestoreStateTaskExecutor, this.cleanRestoreStateTaskExecutor);
        }
    }

    public static RestoreInProgress.State overallState(RestoreInProgress.State nonCompletedState, ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        boolean hasFailed = false;
        for (ObjectCursor status : shards.values()) {
            if (!((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) {
                return nonCompletedState;
            }
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            hasFailed = true;
        }
        if (hasFailed) {
            return RestoreInProgress.State.FAILURE;
        }
        return RestoreInProgress.State.SUCCESS;
    }

    public static boolean completed(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state().completed()) continue;
            return false;
        }
        return true;
    }

    public static int failedShards(ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards) {
        int failedShards = 0;
        for (ObjectCursor status : shards.values()) {
            if (((RestoreInProgress.ShardRestoreStatus)status.value).state() != RestoreInProgress.State.FAILURE) continue;
            ++failedShards;
        }
        return failedShards;
    }

    private Map<String, String> applyRenameToIndices(RestoreRequest request, List<String> indices) {
        HashMap<String, String> renamedIndices = new HashMap<String, String>();
        boolean applyRenamePattern = request.hasNonDefaultRenamePatterns();
        Iterator<String> iterator = indices.iterator();
        while (iterator.hasNext()) {
            String previous;
            String index;
            String renamed = index = iterator.next();
            if (applyRenamePattern) {
                IndexParts indexParts = IndexName.decode(renamed);
                String schema = indexParts.schema();
                String table = indexParts.table();
                table = table.replaceAll(request.tableRenamePattern(), request.tableRenameReplacement());
                schema = schema.replaceAll(request.schemaRenamePattern(), request.schemaRenameReplacement());
                RelationName renamedIdent = new RelationName(schema, table);
                renamed = indexParts.isPartitioned() ? IndexName.encode(renamedIdent.schema(), renamedIdent.name(), indexParts.partitionIdent()) : renamedIdent.indexNameOrAlias();
            }
            if ((previous = renamedIndices.put(renamed, index)) == null) continue;
            throw new SnapshotRestoreException(request.repositoryName, request.snapshotName, "indices [" + index + "] and [" + previous + "] are renamed into the same index [" + renamed + "]");
        }
        return Collections.unmodifiableMap(renamedIndices);
    }

    private void validateSnapshotRestorable(String repository, SnapshotInfo snapshotInfo) {
        if (!snapshotInfo.state().restorable()) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "unsupported snapshot state [" + String.valueOf((Object)snapshotInfo.state()) + "]");
        }
        if (Version.CURRENT.before(snapshotInfo.version())) {
            throw new SnapshotRestoreException(new Snapshot(repository, snapshotInfo.snapshotId()), "the snapshot was created with CrateDB version [" + String.valueOf(snapshotInfo.version()) + "] which is higher than the version of this node [" + String.valueOf(Version.CURRENT) + "]");
        }
    }

    private boolean failed(SnapshotInfo snapshot, String index) {
        for (SnapshotShardFailure failure : snapshot.shardFailures()) {
            if (!index.equals(failure.index())) continue;
            return true;
        }
        return false;
    }

    public static Set<Index> restoringIndices(ClusterState currentState, Set<Index> indicesToCheck) {
        HashSet<Index> indices = new HashSet<Index>();
        for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
            for (ObjectObjectCursor<ShardId, RestoreInProgress.ShardRestoreStatus> objectObjectCursor : entry.shards()) {
                Index index = ((ShardId)objectObjectCursor.key).getIndex();
                if (!indicesToCheck.contains(index) || ((RestoreInProgress.ShardRestoreStatus)objectObjectCursor.value).state().completed() || currentState.metadata().index(index) == null) continue;
                indices.add(index);
            }
        }
        return indices;
    }

    @Override
    public void applyClusterState(ClusterChangedEvent event) {
        try {
            if (event.localNodeMaster()) {
                this.cleanupRestoreState(event);
            }
        }
        catch (Exception t) {
            LOGGER.warn("Failed to update restore state ", (Throwable)t);
        }
    }

    static {
        HashSet<String> unremovable = new HashSet<String>(UNMODIFIABLE_SETTINGS.size() + 4);
        unremovable.addAll(UNMODIFIABLE_SETTINGS);
        unremovable.add("index.number_of_replicas");
        unremovable.add("index.auto_expand_replicas");
        unremovable.add("index.version.upgraded");
        UNREMOVABLE_SETTINGS = Collections.unmodifiableSet(unremovable);
    }

    static class CleanRestoreStateTaskExecutor
    implements ClusterStateTaskExecutor<Task>,
    ClusterStateTaskListener {
        private final Logger logger;

        CleanRestoreStateTaskExecutor(Logger logger) {
            this.logger = logger;
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<Task> execute(ClusterState currentState, List<Task> tasks) throws Exception {
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<Task> resultBuilder = ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks);
            Set completedRestores = tasks.stream().map(e -> e.uuid).collect(Collectors.toSet());
            RestoreInProgress.Builder restoreInProgressBuilder = new RestoreInProgress.Builder();
            boolean changed = false;
            for (RestoreInProgress.Entry entry : currentState.custom("restore", RestoreInProgress.EMPTY)) {
                if (completedRestores.contains(entry.uuid())) {
                    changed = true;
                    continue;
                }
                restoreInProgressBuilder.add(entry);
            }
            if (!changed) {
                return resultBuilder.build(currentState);
            }
            ImmutableOpenMap.Builder<String, ClusterState.Custom> builder = ImmutableOpenMap.builder(currentState.customs());
            builder.put("restore", restoreInProgressBuilder.build());
            ImmutableOpenMap<String, ClusterState.Custom> customs = builder.build();
            return resultBuilder.build(ClusterState.builder(currentState).customs(customs).build());
        }

        @Override
        public void onFailure(String source, Exception e) {
            this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
        }

        @Override
        public void onNoLongerMaster(String source) {
            this.logger.debug("no longer master while processing restore state update [{}]", (Object)source);
        }

        static class Task {
            final String uuid;

            Task(String uuid) {
                this.uuid = uuid;
            }

            public String toString() {
                return "clean restore state for restore " + this.uuid;
            }
        }
    }

    public static class RestoreRequest {
        private final String cause;
        private final String repositoryName;
        private final String snapshotName;
        private final String[] indices;
        private final String[] templates;
        private final String tableRenamePattern;
        private final String tableRenameReplacement;
        private final String schemaRenamePattern;
        private final String schemaRenameReplacement;
        private final IndicesOptions indicesOptions;
        private final Settings settings;
        private final TimeValue masterNodeTimeout;
        private final boolean partial;
        private final boolean includeAliases;
        private final Settings indexSettings;
        private final String[] ignoreIndexSettings;
        private final boolean includeIndices;
        private final boolean includeCustomMetadata;
        private final String[] customMetadataTypes;
        private final boolean includeGlobalSettings;
        private final String[] globalSettings;

        public RestoreRequest(String repositoryName, String snapshotName, String[] indices, String[] templates, IndicesOptions indicesOptions, String tableRenamePattern, String tableRenameReplacement, String schemaRenamePattern, String schemaRenameReplacement, Settings settings, TimeValue masterNodeTimeout, boolean partial, boolean includeAliases, Settings indexSettings, String[] ignoreIndexSettings, String cause, boolean includeIndices, boolean includeCustomMetadata, String[] customMetadataTypes, boolean includeGlobalSettings, String[] globalSettings) {
            this.repositoryName = Objects.requireNonNull(repositoryName);
            this.snapshotName = Objects.requireNonNull(snapshotName);
            this.indices = indices;
            this.templates = templates;
            this.tableRenamePattern = tableRenamePattern;
            this.tableRenameReplacement = tableRenameReplacement;
            this.schemaRenamePattern = schemaRenamePattern;
            this.schemaRenameReplacement = schemaRenameReplacement;
            this.indicesOptions = indicesOptions;
            this.settings = settings;
            this.masterNodeTimeout = masterNodeTimeout;
            this.partial = partial;
            this.includeAliases = includeAliases;
            this.indexSettings = indexSettings;
            this.ignoreIndexSettings = ignoreIndexSettings;
            this.cause = cause;
            this.includeIndices = includeIndices;
            this.includeCustomMetadata = includeCustomMetadata;
            this.customMetadataTypes = customMetadataTypes;
            this.includeGlobalSettings = includeGlobalSettings;
            this.globalSettings = globalSettings;
        }

        public String cause() {
            return this.cause;
        }

        public String repositoryName() {
            return this.repositoryName;
        }

        public String snapshotName() {
            return this.snapshotName;
        }

        public String[] indices() {
            return this.indices;
        }

        public String[] templates() {
            return this.templates;
        }

        public IndicesOptions indicesOptions() {
            return this.indicesOptions;
        }

        public String tableRenamePattern() {
            return this.tableRenamePattern;
        }

        public String tableRenameReplacement() {
            return this.tableRenameReplacement;
        }

        public String schemaRenamePattern() {
            return this.schemaRenamePattern;
        }

        public String schemaRenameReplacement() {
            return this.schemaRenameReplacement;
        }

        public Settings settings() {
            return this.settings;
        }

        public boolean partial() {
            return this.partial;
        }

        public boolean includeAliases() {
            return this.includeAliases;
        }

        public Settings indexSettings() {
            return this.indexSettings;
        }

        public String[] ignoreIndexSettings() {
            return this.ignoreIndexSettings;
        }

        public boolean includeIndices() {
            return this.includeIndices;
        }

        public boolean includeCustomMetadata() {
            return this.includeCustomMetadata;
        }

        public String[] customMetadataTypes() {
            return this.customMetadataTypes;
        }

        public boolean includeGlobalSettings() {
            return this.includeGlobalSettings;
        }

        public String[] globalSettings() {
            return this.globalSettings;
        }

        public TimeValue masterNodeTimeout() {
            return this.masterNodeTimeout;
        }

        public boolean hasNonDefaultRenamePatterns() {
            return !this.tableRenamePattern().equals(SnapshotSettings.TABLE_RENAME_PATTERN.getDefault(Settings.EMPTY)) || !this.tableRenameReplacement().equals(SnapshotSettings.TABLE_RENAME_REPLACEMENT.getDefault(Settings.EMPTY)) || !this.schemaRenamePattern().equals(SnapshotSettings.SCHEMA_RENAME_PATTERN.getDefault(Settings.EMPTY)) || !this.schemaRenameReplacement().equals(SnapshotSettings.SCHEMA_RENAME_REPLACEMENT.getDefault(Settings.EMPTY));
        }

        public boolean restoreAllTables() {
            return this.indices.length == 0 && this.templates.length == 0 && this.includeIndices && this.includeAliases;
        }
    }

    private final class RestoreSnapshotUpdateTask
    extends ClusterStateUpdateTask {
        private final SnapshotInfo snapshotInfo;
        private final SnapshotId snapshotId;
        private final RepositoryData repositoryData;
        private final Snapshot snapshot;
        private final ActionListener<RestoreCompletionResponse> listener;
        private final RestoreRequest request;
        private final Map<String, String> indices;
        private final List<String> templates;
        private final Metadata metadata;
        final String restoreUUID = UUIDs.randomBase64UUID();
        RestoreInfo restoreInfo = null;

        private RestoreSnapshotUpdateTask(SnapshotInfo snapshotInfo, SnapshotId snapshotId, RepositoryData repositoryData, Snapshot snapshot, ActionListener<RestoreCompletionResponse> listener, RestoreRequest request, Map<String, String> indices, List<String> templates, Metadata metadata) {
            this.snapshotInfo = snapshotInfo;
            this.snapshotId = snapshotId;
            this.repositoryData = repositoryData;
            this.snapshot = snapshot;
            this.listener = listener;
            this.request = request;
            this.indices = indices;
            this.templates = templates;
            this.metadata = metadata;
        }

        @Override
        public ClusterState execute(ClusterState currentState) {
            ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards;
            SnapshotDeletionsInProgress deletionsInProgress = currentState.custom("snapshot_deletions", SnapshotDeletionsInProgress.EMPTY);
            if (deletionsInProgress.getEntries().stream().anyMatch(entry -> entry.getSnapshots().contains(this.snapshotId))) {
                throw new ConcurrentSnapshotExecutionException(this.snapshot, "cannot restore a snapshot while a snapshot deletion is in-progress [" + String.valueOf(deletionsInProgress.getEntries().get(0)) + "]");
            }
            ClusterState.Builder builder = ClusterState.builder(currentState);
            Metadata.Builder mdBuilder = Metadata.builder(currentState.metadata());
            ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
            RoutingTable.Builder rtBuilder = RoutingTable.builder(currentState.routingTable());
            HashSet<String> aliases = new HashSet<String>();
            if (!this.indices.isEmpty()) {
                ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder();
                Version minIndexCompatibilityVersion = currentState.nodes().getMaxNodeVersion().minimumIndexCompatibilityVersion();
                for (Map.Entry<String, String> indexEntry : this.indices.entrySet()) {
                    Index renamedIndex;
                    String index = indexEntry.getValue();
                    boolean partial = this.checkPartial(index);
                    RecoverySource.SnapshotRecoverySource recoverySource = new RecoverySource.SnapshotRecoverySource(this.restoreUUID, this.snapshot, this.snapshotInfo.version(), this.repositoryData.resolveIndexId(index));
                    IndexMetadata snapshotIndexMetadata = this.metadata.index(index);
                    if (snapshotIndexMetadata == null) {
                        throw new IndexNotFoundException("Failed to find index '" + index + "' at the metadata of the current snapshot '" + String.valueOf(this.snapshot) + "'", index);
                    }
                    snapshotIndexMetadata = this.updateIndexSettings(snapshotIndexMetadata, this.request.indexSettings(), this.request.ignoreIndexSettings());
                    try {
                        String indexName = snapshotIndexMetadata.getIndex().getName();
                        snapshotIndexMetadata = RestoreService.this.metadataIndexUpgradeService.upgradeIndexMetadata(snapshotIndexMetadata, IndexName.isPartitioned(indexName) ? currentState.metadata().templates().get(PartitionName.templateName(indexName)) : null, minIndexCompatibilityVersion, null);
                    }
                    catch (Exception ex) {
                        throw new SnapshotRestoreException(this.snapshot, "cannot restore index [" + index + "] because it cannot be upgraded", ex);
                    }
                    String renamedIndexName = indexEntry.getKey();
                    IndexMetadata currentIndexMetadata = currentState.metadata().index(renamedIndexName);
                    IntHashSet ignoreShards = new IntHashSet();
                    if (currentIndexMetadata == null) {
                        IndexName.validate(renamedIndexName);
                        RestoreService.this.createIndexService.validateIndexSettings(renamedIndexName, snapshotIndexMetadata.getSettings(), false);
                        indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN).index(renamedIndexName);
                        if (this.request.hasNonDefaultRenamePatterns() && !snapshotIndexMetadata.getAliases().isEmpty()) {
                            String renamedAlias = RelationName.fromIndexName(renamedIndexName).indexNameOrAlias();
                            indexMdBuilder.removeAllAliases();
                            indexMdBuilder.putAlias(new AliasMetadata(renamedAlias));
                        }
                        Settings.Builder indexSettingsBuilder = Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", UUIDs.randomBase64UUID());
                        if (snapshotIndexMetadata.getCreationVersion().onOrAfter(Version.V_5_1_0) || currentState.nodes().getMinNodeVersion().onOrAfter(Version.V_5_1_0)) {
                            indexSettingsBuilder.put("index.history.uuid", UUIDs.randomBase64UUID());
                        }
                        indexMdBuilder.settings(indexSettingsBuilder);
                        RestoreService.this.shardLimitValidator.validateShardLimit(snapshotIndexMetadata.getSettings(), currentState);
                        if (!this.request.includeAliases() && !snapshotIndexMetadata.getAliases().isEmpty()) {
                            indexMdBuilder.removeAllAliases();
                        } else {
                            for (ObjectCursor alias : snapshotIndexMetadata.getAliases().keys()) {
                                aliases.add((String)alias.value);
                            }
                        }
                        IndexMetadata updatedIndexMetadata = indexMdBuilder.build();
                        if (partial) {
                            this.populateIgnoredShards(index, (IntSet)ignoreShards);
                        }
                        rtBuilder.addAsNewRestore(updatedIndexMetadata, recoverySource, (IntSet)ignoreShards);
                        blocks.addBlocks(updatedIndexMetadata);
                        mdBuilder.put(updatedIndexMetadata, true);
                        renamedIndex = updatedIndexMetadata.getIndex();
                    } else {
                        this.validateExistingIndex(currentIndexMetadata, snapshotIndexMetadata, renamedIndexName, partial);
                        indexMdBuilder = IndexMetadata.builder(snapshotIndexMetadata).state(IndexMetadata.State.OPEN);
                        indexMdBuilder.version(Math.max(snapshotIndexMetadata.getVersion(), 1L + currentIndexMetadata.getVersion()));
                        indexMdBuilder.mappingVersion(Math.max(snapshotIndexMetadata.getMappingVersion(), 1L + currentIndexMetadata.getMappingVersion()));
                        indexMdBuilder.settingsVersion(Math.max(snapshotIndexMetadata.getSettingsVersion(), 1L + currentIndexMetadata.getSettingsVersion()));
                        for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                            indexMdBuilder.primaryTerm(shard, Math.max(snapshotIndexMetadata.primaryTerm(shard), currentIndexMetadata.primaryTerm(shard)));
                        }
                        if (!this.request.includeAliases()) {
                            if (!snapshotIndexMetadata.getAliases().isEmpty()) {
                                indexMdBuilder.removeAllAliases();
                            }
                            for (ObjectCursor alias : currentIndexMetadata.getAliases().values()) {
                                indexMdBuilder.putAlias((AliasMetadata)alias.value);
                            }
                        } else {
                            for (ObjectCursor alias : snapshotIndexMetadata.getAliases().keys()) {
                                aliases.add((String)alias.value);
                            }
                        }
                        indexMdBuilder.settings(Settings.builder().put(snapshotIndexMetadata.getSettings()).put("index.uuid", currentIndexMetadata.getIndexUUID()));
                        IndexMetadata updatedIndexMetadata = indexMdBuilder.index(renamedIndexName).build();
                        rtBuilder.addAsRestore(updatedIndexMetadata, recoverySource);
                        blocks.updateBlocks(updatedIndexMetadata);
                        mdBuilder.put(updatedIndexMetadata, true);
                        renamedIndex = updatedIndexMetadata.getIndex();
                    }
                    for (int shard = 0; shard < snapshotIndexMetadata.getNumberOfShards(); ++shard) {
                        if (!ignoreShards.contains(shard)) {
                            shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId()));
                            continue;
                        }
                        shardsBuilder.put(new ShardId(renamedIndex, shard), new RestoreInProgress.ShardRestoreStatus(RestoreService.this.clusterService.state().nodes().getLocalNodeId(), RestoreInProgress.State.FAILURE));
                    }
                }
                shards = shardsBuilder.build();
                RestoreInProgress.Entry restoreEntry = new RestoreInProgress.Entry(this.restoreUUID, this.snapshot, RestoreService.overallState(RestoreInProgress.State.INIT, shards), List.copyOf(this.indices.keySet()), shards);
                builder.putCustom("restore", new RestoreInProgress.Builder(currentState.custom("restore", RestoreInProgress.EMPTY)).add(restoreEntry).build());
            } else {
                shards = ImmutableOpenMap.of();
            }
            this.validateExistingTemplates(this.templates);
            this.checkAliasNameConflicts(this.indices, aliases);
            this.restoreTemplates(this.templates, mdBuilder, currentState);
            if (this.request.includeGlobalSettings() && this.metadata.persistentSettings() != null) {
                Settings settings = this.metadata.persistentSettings();
                if (this.request.globalSettings().length > 0) {
                    Settings.Builder filteredSettingBuilder = Settings.builder();
                    for (String prefix : this.request.globalSettings()) {
                        filteredSettingBuilder.put(settings.filter(s -> s.startsWith(prefix)));
                    }
                    settings = filteredSettingBuilder.build();
                }
                RestoreService.this.clusterSettings.validateUpdate(settings);
                mdBuilder.persistentSettings(settings);
            }
            if (this.request.includeCustomMetadata() && this.metadata.customs() != null) {
                List<String> customMetadataTypes = Arrays.asList(this.request.customMetadataTypes());
                boolean includeAll = customMetadataTypes.size() == 0;
                for (ObjectObjectCursor cursor : this.metadata.customs()) {
                    if ("repositories".equals(cursor.key) || !includeAll && !customMetadataTypes.contains(cursor.key)) continue;
                    mdBuilder.putCustom((String)cursor.key, (Metadata.Custom)cursor.value);
                }
            }
            if (RestoreService.completed(shards)) {
                this.restoreInfo = new RestoreInfo(this.snapshotId.getName(), Collections.unmodifiableList(new ArrayList<String>(this.indices.keySet())), shards.size(), shards.size() - RestoreService.failedShards(shards));
            }
            RoutingTable rt = rtBuilder.build();
            ClusterState updatedState = builder.metadata(mdBuilder).blocks(blocks).routingTable(rt).build();
            return RestoreService.this.allocationService.reroute(updatedState, "restored snapshot [" + String.valueOf(this.snapshot) + "]");
        }

        private void checkAliasNameConflicts(Map<String, String> renamedIndices, Set<String> aliases) {
            for (Map.Entry<String, String> renamedIndex : renamedIndices.entrySet()) {
                if (!aliases.contains(renamedIndex.getKey())) continue;
                throw new SnapshotRestoreException(this.snapshot, "cannot rename index [" + renamedIndex.getValue() + "] into [" + renamedIndex.getKey() + "] because of conflict with an alias with the same name");
            }
        }

        private void populateIgnoredShards(String index, IntSet ignoreShards) {
            for (SnapshotShardFailure failure : this.snapshotInfo.shardFailures()) {
                if (!index.equals(failure.index())) continue;
                ignoreShards.add(failure.shardId());
            }
        }

        private boolean checkPartial(String index) {
            if (RestoreService.this.failed(this.snapshotInfo, index)) {
                if (this.request.partial()) {
                    return true;
                }
                throw new SnapshotRestoreException(this.snapshot, "index [" + index + "] wasn't fully snapshotted - cannot restore");
            }
            return false;
        }

        private void validateExistingIndex(IndexMetadata currentIndexMetadata, IndexMetadata snapshotIndexMetadata, String renamedIndex, boolean partial) {
            if (currentIndexMetadata.getState() != IndexMetadata.State.CLOSE) {
                IndexParts indexParts = IndexName.decode(renamedIndex);
                RelationName relationName = new RelationName(indexParts.schema(), indexParts.table());
                if (indexParts.isPartitioned()) {
                    throw new PartitionAlreadyExistsException(new PartitionName(relationName, indexParts.partitionIdent()));
                }
                throw new RelationAlreadyExists(relationName);
            }
            if (partial) {
                throw new SnapshotRestoreException(this.snapshot, "cannot restore partial index [" + renamedIndex + "] because such index already exists");
            }
            if (currentIndexMetadata.getNumberOfShards() != snapshotIndexMetadata.getNumberOfShards()) {
                throw new SnapshotRestoreException(this.snapshot, "cannot restore index [" + renamedIndex + "] with [" + currentIndexMetadata.getNumberOfShards() + "] shards from a snapshot of index [" + snapshotIndexMetadata.getIndex().getName() + "] with [" + snapshotIndexMetadata.getNumberOfShards() + "] shards");
            }
        }

        private IndexMetadata updateIndexSettings(IndexMetadata indexMetadata, Settings changeSettings, String[] ignoreSettings) {
            if (changeSettings.names().isEmpty() && ignoreSettings.length == 0) {
                return indexMetadata;
            }
            Settings normalizedChangeSettings = Settings.builder().put(changeSettings).normalizePrefix("index.").build();
            IndexMetadata.Builder builder = IndexMetadata.builder(indexMetadata);
            Settings settings = indexMetadata.getSettings();
            HashSet<String> keyFilters = new HashSet<String>();
            ArrayList<String> simpleMatchPatterns = new ArrayList<String>();
            for (String ignoredSetting : ignoreSettings) {
                if (!Regex.isSimpleMatchPattern(ignoredSetting)) {
                    if (UNREMOVABLE_SETTINGS.contains(ignoredSetting)) {
                        throw new SnapshotRestoreException(this.snapshot, "cannot remove setting [" + ignoredSetting + "] on restore");
                    }
                    keyFilters.add(ignoredSetting);
                    continue;
                }
                simpleMatchPatterns.add(ignoredSetting);
            }
            Predicate<String> settingsFilter = k -> {
                if (!UNREMOVABLE_SETTINGS.contains(k)) {
                    for (String filterKey : keyFilters) {
                        if (!k.equals(filterKey)) continue;
                        return false;
                    }
                    for (String pattern : simpleMatchPatterns) {
                        if (!Regex.simpleMatch(pattern, k)) continue;
                        return false;
                    }
                }
                return true;
            };
            Settings.Builder settingsBuilder = Settings.builder().put(settings.filter(settingsFilter)).put(normalizedChangeSettings.filter(k -> {
                if (UNMODIFIABLE_SETTINGS.contains(k)) {
                    throw new SnapshotRestoreException(this.snapshot, "cannot modify setting [" + k + "] on restore");
                }
                return true;
            }));
            settingsBuilder.remove(IndexMetadata.VERIFIED_BEFORE_CLOSE_SETTING.getKey());
            return builder.settings(settingsBuilder).build();
        }

        private void restoreTemplates(List<String> templates, Metadata.Builder mdBuilder, ClusterState currentState) {
            ImmutableOpenMap<String, IndexTemplateMetadata> templateMetadata = this.metadata.templates();
            if (templateMetadata == null) {
                return;
            }
            Map<String, IndexTemplateMetadata> includedTemplates = new HashMap();
            boolean allTemplates = RestoreService.this.allTemplates(templates);
            boolean applyRenamePattern = this.request.hasNonDefaultRenamePatterns();
            for (ObjectObjectCursor<String, IndexTemplateMetadata> objectObjectCursor : templateMetadata) {
                IndexTemplateMetadata previous;
                String templateName = (String)objectObjectCursor.key;
                IndexTemplateMetadata indexTemplateMetadata = (IndexTemplateMetadata)objectObjectCursor.value;
                if (!allTemplates && !templates.contains(templateName)) continue;
                if (applyRenamePattern) {
                    IndexParts indexParts = IndexName.decode(templateName);
                    String schema = indexParts.schema();
                    String table = indexParts.table();
                    RelationName newName = new RelationName(schema.replaceAll(this.request.schemaRenamePattern(), this.request.schemaRenameReplacement()), table.replaceAll(this.request.tableRenamePattern(), this.request.tableRenameReplacement()));
                    IndexTemplateMetadata renamedIndexTemplateMetadata = Templates.withName(indexTemplateMetadata, newName).build();
                    previous = includedTemplates.put(newName.indexNameOrAlias(), renamedIndexTemplateMetadata);
                } else {
                    previous = includedTemplates.put(templateName, indexTemplateMetadata);
                }
                if (previous == null) continue;
                throw new SnapshotRestoreException(this.request.repositoryName, this.request.snapshotName, String.format(Locale.ENGLISH, "Rename conflict for partitioned table `%s`. `%s` already exists. Cannot rename `%s` to the same name", IndexName.decode(templateName).toRelationName().fqn(), templateName, previous.name()));
            }
            includedTemplates = (Map)RestoreService.this.metadataUpgrader.indexTemplateMetadataUpgraders.apply(includedTemplates);
            for (IndexTemplateMetadata indexTemplateMetadata : includedTemplates.values()) {
                mdBuilder.put(indexTemplateMetadata);
            }
        }

        private void validateExistingTemplates(List<String> templates) {
            if (this.request.indicesOptions().ignoreUnavailable() || RestoreService.this.allTemplates(templates)) {
                return;
            }
            for (String template : templates) {
                if (this.metadata.templates().containsKey(template)) continue;
                throw new ResourceNotFoundException("[{}] template not found", template);
            }
        }

        @Override
        public void onFailure(String source, Exception e) {
            LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to restore snapshot", (Object)this.snapshotId), (Throwable)e);
            this.listener.onFailure(e);
        }

        @Override
        public TimeValue timeout() {
            return this.request.masterNodeTimeout();
        }

        @Override
        public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            this.listener.onResponse(new RestoreCompletionResponse(this.restoreUUID, this.snapshot, this.restoreInfo));
        }
    }

    public static class RestoreInProgressUpdater
    extends RoutingChangesObserver.AbstractRoutingChangesObserver {
        private final Map<String, Updates> shardChanges = new HashMap<String, Updates>();

        @Override
        public void shardStarted(ShardRouting initializingShard, ShardRouting startedShard) {
            RecoverySource recoverySource;
            if (initializingShard.primary() && (recoverySource = initializingShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT) {
                this.changes((RecoverySource)recoverySource).shards.put(initializingShard.shardId(), new RestoreInProgress.ShardRestoreStatus(initializingShard.currentNodeId(), RestoreInProgress.State.SUCCESS));
            }
        }

        @Override
        public void shardFailed(ShardRouting failedShard, UnassignedInfo unassignedInfo) {
            RecoverySource recoverySource;
            if (failedShard.primary() && failedShard.initializing() && (recoverySource = failedShard.recoverySource()).getType() == RecoverySource.Type.SNAPSHOT && unassignedInfo.getFailure() != null && Lucene.isCorruptionException(unassignedInfo.getFailure().getCause())) {
                this.changes((RecoverySource)recoverySource).shards.put(failedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(failedShard.currentNodeId(), RestoreInProgress.State.FAILURE, unassignedInfo.getFailure().getCause().getMessage()));
            }
        }

        @Override
        public void shardInitialized(ShardRouting unassignedShard, ShardRouting initializedShard) {
            if (unassignedShard.recoverySource().getType() == RecoverySource.Type.SNAPSHOT && initializedShard.recoverySource().getType() != RecoverySource.Type.SNAPSHOT) {
                this.changes((RecoverySource)unassignedShard.recoverySource()).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(null, RestoreInProgress.State.FAILURE, "recovery source type changed from snapshot to " + String.valueOf(initializedShard.recoverySource())));
            }
        }

        @Override
        public void unassignedInfoUpdated(ShardRouting unassignedShard, UnassignedInfo newUnassignedInfo) {
            RecoverySource recoverySource = unassignedShard.recoverySource();
            if (recoverySource.getType() == RecoverySource.Type.SNAPSHOT && newUnassignedInfo.getLastAllocationStatus() == UnassignedInfo.AllocationStatus.DECIDERS_NO) {
                String reason = "shard could not be allocated to any of the nodes";
                this.changes((RecoverySource)recoverySource).shards.put(unassignedShard.shardId(), new RestoreInProgress.ShardRestoreStatus(unassignedShard.currentNodeId(), RestoreInProgress.State.FAILURE, reason));
            }
        }

        private Updates changes(RecoverySource recoverySource) {
            assert (recoverySource.getType() == RecoverySource.Type.SNAPSHOT);
            return this.shardChanges.computeIfAbsent(((RecoverySource.SnapshotRecoverySource)recoverySource).restoreUUID(), k -> new Updates());
        }

        public RestoreInProgress applyChanges(RestoreInProgress oldRestore) {
            if (!this.shardChanges.isEmpty()) {
                RestoreInProgress.Builder builder = new RestoreInProgress.Builder();
                for (RestoreInProgress.Entry entry : oldRestore) {
                    Updates updates = this.shardChanges.get(entry.uuid());
                    ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shardStates = entry.shards();
                    if (updates != null && !updates.shards.isEmpty()) {
                        ImmutableOpenMap.Builder<ShardId, RestoreInProgress.ShardRestoreStatus> shardsBuilder = ImmutableOpenMap.builder(shardStates);
                        for (Map.Entry<ShardId, RestoreInProgress.ShardRestoreStatus> shard : updates.shards.entrySet()) {
                            ShardId shardId = shard.getKey();
                            RestoreInProgress.ShardRestoreStatus status = shardStates.get(shardId);
                            if (status != null && status.state().completed()) continue;
                            shardsBuilder.put(shardId, shard.getValue());
                        }
                        ImmutableOpenMap<ShardId, RestoreInProgress.ShardRestoreStatus> shards = shardsBuilder.build();
                        RestoreInProgress.State newState = RestoreService.overallState(RestoreInProgress.State.STARTED, shards);
                        builder.add(new RestoreInProgress.Entry(entry.uuid(), entry.snapshot(), newState, entry.indices(), shards));
                        continue;
                    }
                    builder.add(entry);
                }
                return builder.build();
            }
            return oldRestore;
        }

        private static class Updates {
            private Map<ShardId, RestoreInProgress.ShardRestoreStatus> shards = new HashMap<ShardId, RestoreInProgress.ShardRestoreStatus>();

            private Updates() {
            }
        }
    }

    public static final class RestoreCompletionResponse {
        private final String uuid;
        private final Snapshot snapshot;
        private final RestoreInfo restoreInfo;

        private RestoreCompletionResponse(String uuid, Snapshot snapshot, RestoreInfo restoreInfo) {
            this.uuid = uuid;
            this.snapshot = snapshot;
            this.restoreInfo = restoreInfo;
        }

        public String getUuid() {
            return this.uuid;
        }

        public Snapshot getSnapshot() {
            return this.snapshot;
        }

        public RestoreInfo getRestoreInfo() {
            return this.restoreInfo;
        }
    }
}

