/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import java.io.IOException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.NotNull;

public class ThreadPoolStats
extends AbstractList<Stats>
implements Writeable {
    private List<Stats> stats;

    public ThreadPoolStats(List<Stats> stats) {
        Collections.sort(stats);
        this.stats = stats;
    }

    public ThreadPoolStats(StreamInput in) throws IOException {
        this.stats = in.readList(Stats::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeList(this.stats);
    }

    @Override
    public Stats get(int index) {
        return this.stats.get(index);
    }

    @Override
    @NotNull
    public Iterator<Stats> iterator() {
        return this.stats.iterator();
    }

    @Override
    public int size() {
        return this.stats.size();
    }

    public static class Stats
    implements Writeable,
    Comparable<Stats> {
        private final String name;
        private final int threads;
        private final int queue;
        private final int active;
        private final long rejected;
        private final int largest;
        private final long completed;

        public Stats(String name, int threads, int queue, int active, long rejected, int largest, long completed) {
            this.name = name;
            this.threads = threads;
            this.queue = queue;
            this.active = active;
            this.rejected = rejected;
            this.largest = largest;
            this.completed = completed;
        }

        public Stats(StreamInput in) throws IOException {
            this.name = in.readString();
            this.threads = in.readInt();
            this.queue = in.readInt();
            this.active = in.readInt();
            this.rejected = in.readLong();
            this.largest = in.readInt();
            this.completed = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeInt(this.threads);
            out.writeInt(this.queue);
            out.writeInt(this.active);
            out.writeLong(this.rejected);
            out.writeInt(this.largest);
            out.writeLong(this.completed);
        }

        public String getName() {
            return this.name;
        }

        public int getThreads() {
            return this.threads;
        }

        public int getQueue() {
            return this.queue;
        }

        public int getActive() {
            return this.active;
        }

        public long getRejected() {
            return this.rejected;
        }

        public int getLargest() {
            return this.largest;
        }

        public long getCompleted() {
            return this.completed;
        }

        @Override
        public int compareTo(Stats other) {
            if (this.getName() == null && other.getName() == null) {
                return 0;
            }
            if (this.getName() != null && other.getName() == null) {
                return 1;
            }
            if (this.getName() == null) {
                return -1;
            }
            int compare = this.getName().compareTo(other.getName());
            if (compare == 0) {
                compare = Integer.compare(this.getThreads(), other.getThreads());
            }
            return compare;
        }
    }
}

