/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.OutboundMessage;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.StatsTracker;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.netty4.Netty4Utils;

public final class OutboundHandler {
    private static final Logger LOGGER = LogManager.getLogger(OutboundHandler.class);
    private final String nodeName;
    private final Version version;
    private final StatsTracker statsTracker;
    private final ThreadPool threadPool;
    private final BigArrays bigArrays;
    private volatile TransportMessageListener messageListener = TransportMessageListener.NOOP_LISTENER;

    OutboundHandler(String nodeName, Version version, StatsTracker statsTracker, ThreadPool threadPool, BigArrays bigArrays) {
        this.nodeName = nodeName;
        this.version = version;
        this.statsTracker = statsTracker;
        this.threadPool = threadPool;
        this.bigArrays = bigArrays;
    }

    ChannelFuture sendBytes(CloseableChannel channel, byte[] bytes) {
        channel.markAccessed(this.threadPool.relativeTimeInMillis());
        try {
            ChannelFuture future = channel.writeAndFlush(Unpooled.wrappedBuffer((byte[])bytes));
            future.addListener(f -> {
                if (f.isSuccess()) {
                    this.statsTracker.incrementBytesSent(bytes.length);
                } else {
                    LOGGER.warn("send message failed [channel: {}]", (Object)channel, (Object)f.cause());
                }
            });
            return future;
        }
        catch (RuntimeException ex) {
            channel.close();
            throw ex;
        }
    }

    public void sendRequest(DiscoveryNode node, CloseableChannel channel, long requestId, String action, TransportRequest request, TransportRequestOptions options, Version channelVersion, boolean compressRequest, boolean isHandshake) throws IOException, TransportException {
        Version version = Version.min(this.version, channelVersion);
        OutboundMessage.Request message = new OutboundMessage.Request(request, version, action, requestId, isHandshake, compressRequest);
        ChannelFuture future = this.sendMessage(channel, message);
        future.addListener(f -> this.messageListener.onRequestSent(node, requestId, action, request, options));
    }

    void sendResponse(Version nodeVersion, CloseableChannel channel, long requestId, String action, TransportResponse response, boolean compress, boolean isHandshake) throws IOException {
        Version version = Version.min(this.version, nodeVersion);
        OutboundMessage.Response message = new OutboundMessage.Response(response, version, requestId, isHandshake, compress);
        ChannelFuture future = this.sendMessage(channel, message);
        future.addListener(f -> this.messageListener.onResponseSent(requestId, action, response));
    }

    void sendErrorResponse(Version nodeVersion, CloseableChannel channel, long requestId, String action, Exception error) throws IOException {
        Version version = Version.min(this.version, nodeVersion);
        TransportAddress address = new TransportAddress(channel.getLocalAddress());
        RemoteTransportException tx = new RemoteTransportException(this.nodeName, address, action, error);
        OutboundMessage.Response message = new OutboundMessage.Response(tx, version, requestId, false, false);
        ChannelFuture future = this.sendMessage(channel, message);
        future.addListener(f -> this.messageListener.onResponseSent(requestId, action, error));
    }

    private ChannelFuture sendMessage(CloseableChannel channel, OutboundMessage networkMessage) throws IOException {
        channel.markAccessed(this.threadPool.relativeTimeInMillis());
        ReleasableBytesStreamOutput bytesStreamOutput = new ReleasableBytesStreamOutput(this.bigArrays);
        try {
            BytesReference msg = networkMessage.serialize(bytesStreamOutput);
            ChannelFuture future = channel.writeAndFlush(Netty4Utils.toByteBuf(msg));
            future.addListener(f -> {
                this.statsTracker.incrementBytesSent(msg.length());
                bytesStreamOutput.close();
                if (!f.isSuccess()) {
                    LOGGER.warn("send message failed [channel: {}]", (Object)channel, (Object)f.cause());
                }
            });
            return future;
        }
        catch (RuntimeException ex) {
            bytesStreamOutput.close();
            channel.close();
            throw ex;
        }
    }

    void setMessageListener(TransportMessageListener listener) {
        if (this.messageListener != TransportMessageListener.NOOP_LISTENER) {
            throw new IllegalStateException("Cannot set message listener twice");
        }
        this.messageListener = listener;
    }
}

