/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;

public final class ProxyConnection
implements Transport.Connection {
    private final Transport.Connection connection;
    private final DiscoveryNode targetNode;

    public ProxyConnection(Transport.Connection connection, DiscoveryNode targetNode) {
        this.connection = connection;
        this.targetNode = targetNode;
    }

    @Override
    public DiscoveryNode getNode() {
        return this.targetNode;
    }

    @Override
    public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
        this.connection.sendRequest(requestId, TransportActionProxy.getProxyAction(action), TransportActionProxy.wrapRequest(this.targetNode, request), options);
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.connection.addCloseListener(listener);
    }

    @Override
    public boolean isClosed() {
        return this.connection.isClosed();
    }

    @Override
    public void close() {
        assert (false) : "Proxy connections must not be closed";
    }

    @Override
    public Version getVersion() {
        return this.connection.getVersion();
    }

    @Override
    public Object getCacheKey() {
        return this.connection.getCacheKey();
    }
}

