/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.io.IOUtils;
import io.crate.protocols.postgres.PgClient;
import io.crate.protocols.postgres.PgClientFactory;
import io.crate.replication.logical.metadata.ConnectionInfo;
import io.crate.types.DataTypes;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.SniffRemoteClient;
import org.elasticsearch.transport.TransportService;

public class RemoteCluster
implements Closeable {
    public static final Setting<ConnectionStrategy> REMOTE_CONNECTION_MODE = new Setting<ConnectionStrategy>("mode", ConnectionStrategy.SNIFF.name(), value -> switch (value.toLowerCase(Locale.ENGLISH)) {
        case "sniff" -> ConnectionStrategy.SNIFF;
        case "pg_tunnel" -> ConnectionStrategy.PG_TUNNEL;
        default -> throw new IllegalArgumentException("Invalid connection mode `" + value + "`, supported modes are: `sniff`, `pg_tunnel`");
    }, DataTypes.STRING, Setting.Property.Dynamic);
    private final String clusterName;
    private final ConnectionInfo connectionInfo;
    private final TransportService transportService;
    private final ConnectionStrategy connectionStrategy;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final List<Closeable> toClose = new ArrayList<Closeable>();
    private final PgClientFactory pgClientFactory;
    private volatile Client client;

    public RemoteCluster(String name, Settings settings, ConnectionInfo connectionInfo, PgClientFactory pgClientFactory, ThreadPool threadPool, TransportService transportService) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.clusterName = name;
        this.connectionInfo = connectionInfo;
        this.pgClientFactory = pgClientFactory;
        this.transportService = transportService;
        this.connectionStrategy = connectionInfo.mode();
    }

    public Client client() {
        return this.client;
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.toClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Client> connectAndGetClient() {
        RemoteCluster remoteCluster = this;
        synchronized (remoteCluster) {
            Client currentClient = this.client;
            if (currentClient != null) {
                return CompletableFuture.completedFuture(currentClient);
            }
        }
        CompletableFuture<Client> futureClient = switch (this.connectionStrategy.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.connectSniff();
            case 1 -> this.connectPgTunnel();
        };
        return futureClient.whenComplete((c, err) -> {
            this.client = c;
        });
    }

    private CompletableFuture<Client> connectPgTunnel() {
        try {
            PgClient pgClient = this.pgClientFactory.createClient(this.clusterName, this.connectionInfo);
            this.toClose.add(pgClient);
            return pgClient.ensureConnected().thenApply(connection -> pgClient);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private CompletableFuture<Client> connectSniff() {
        SniffRemoteClient sniffClient = new SniffRemoteClient(this.settings, this.threadPool, this.connectionInfo, this.clusterName, this.transportService);
        this.toClose.add(sniffClient);
        try {
            return sniffClient.ensureConnected(null).thenApply(ignored -> sniffClient);
        }
        catch (Throwable e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public static enum ConnectionStrategy {
        SNIFF,
        PG_TUNNEL;

    }
}

