/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.unit.TimeValue;
import java.io.EOFException;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.jetbrains.annotations.VisibleForTesting;

final class TransportHandshaker {
    static final String HANDSHAKE_ACTION_NAME = "internal:tcp/handshake";
    private final ConcurrentMap<Long, HandshakeResponseHandler> pendingHandshakes = new ConcurrentHashMap<Long, HandshakeResponseHandler>();
    private final CounterMetric numHandshakes = new CounterMetric();
    private final Version version;
    private final ThreadPool threadPool;
    private final HandshakeRequestSender handshakeRequestSender;

    TransportHandshaker(Version version, ThreadPool threadPool, HandshakeRequestSender handshakeRequestSender) {
        this.version = version;
        this.threadPool = threadPool;
        this.handshakeRequestSender = handshakeRequestSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendHandshake(long requestId, DiscoveryNode node, CloseableChannel channel, TimeValue timeout, ActionListener<Version> listener) {
        block5: {
            this.numHandshakes.inc();
            HandshakeResponseHandler handler = new HandshakeResponseHandler(requestId, this.version, listener);
            this.pendingHandshakes.put(requestId, handler);
            channel.addCloseListener(ActionListener.wrap(() -> handler.handleLocalException(new TransportException("handshake failed because connection reset"))));
            boolean success = false;
            try {
                this.handshakeRequestSender.sendRequest(node, channel, requestId, this.version);
                this.threadPool.schedule(() -> handler.handleLocalException(new ConnectTransportException(node, "handshake_timeout[" + String.valueOf(timeout) + "]")), timeout, "generic");
                success = true;
            }
            catch (Exception e) {
                handler.handleLocalException(new ConnectTransportException(node, "failure to send internal:tcp/handshake", e));
            }
            finally {
                if (success) break block5;
                TransportResponseHandler removed = (TransportResponseHandler)this.pendingHandshakes.remove(requestId);
                if ($assertionsDisabled || removed == null) break block5;
                throw new AssertionError((Object)"Handshake should not be pending if exception was thrown");
            }
        }
    }

    void handleHandshake(TransportChannel channel, long requestId, StreamInput stream) throws IOException {
        HandshakeRequest request = new HandshakeRequest(stream);
        if (!stream.getVersion().equals(this.version) && !this.version.isCompatible(stream.getVersion(), request.minimumCompatibilityVersion)) {
            IllegalStateException invalidVersion = new IllegalStateException("Received handshake message from unsupported version: [" + String.valueOf(stream.getVersion()) + "] minimal compatible version is: [" + String.valueOf(this.version.minimumCompatibilityVersion()) + "]");
            channel.sendResponse(invalidVersion);
            throw invalidVersion;
        }
        int nextByte = stream.read();
        if (nextByte != -1) {
            throw new IllegalStateException("Handshake request not fully read for requestId [" + requestId + "], action [internal:tcp/handshake], available [" + stream.available() + "]; resetting");
        }
        channel.sendResponse(new HandshakeResponse(this.version));
    }

    TransportResponseHandler<HandshakeResponse> removeHandlerForHandshake(long requestId) {
        return (TransportResponseHandler)this.pendingHandshakes.remove(requestId);
    }

    int getNumPendingHandshakes() {
        return this.pendingHandshakes.size();
    }

    long getNumHandshakes() {
        return this.numHandshakes.count();
    }

    @FunctionalInterface
    static interface HandshakeRequestSender {
        public void sendRequest(DiscoveryNode var1, CloseableChannel var2, long var3, Version var5) throws IOException;
    }

    private class HandshakeResponseHandler
    implements TransportResponseHandler<HandshakeResponse> {
        private final long requestId;
        private final Version currentVersion;
        private final ActionListener<Version> listener;
        private final AtomicBoolean isDone = new AtomicBoolean(false);

        private HandshakeResponseHandler(long requestId, Version currentVersion, ActionListener<Version> listener) {
            this.requestId = requestId;
            this.currentVersion = currentVersion;
            this.listener = listener;
        }

        @Override
        public HandshakeResponse read(StreamInput in) throws IOException {
            return new HandshakeResponse(in);
        }

        @Override
        public void handleResponse(HandshakeResponse response) {
            if (this.isDone.compareAndSet(false, true)) {
                Version remoteMinimalCompatibleVersion;
                Version remoteVersion = response.getResponseVersion();
                if (!this.currentVersion.isCompatible(remoteVersion, remoteMinimalCompatibleVersion = response.responseMinimalCompatibleVersion())) {
                    this.listener.onFailure(new IllegalStateException("Received message from unsupported version: [" + String.valueOf(remoteVersion) + "] minimal compatible version is: [" + String.valueOf(this.currentVersion.minimumCompatibilityVersion()) + "]"));
                } else {
                    this.listener.onResponse(remoteVersion);
                }
            }
        }

        @Override
        public void handleException(TransportException e) {
            if (this.isDone.compareAndSet(false, true)) {
                this.listener.onFailure(new IllegalStateException("handshake failed", e));
            }
        }

        void handleLocalException(TransportException e) {
            if (TransportHandshaker.this.removeHandlerForHandshake(this.requestId) != null && this.isDone.compareAndSet(false, true)) {
                this.listener.onFailure(e);
            }
        }

        @Override
        public String executor() {
            return "same";
        }
    }

    static final class HandshakeRequest
    extends TransportRequest {
        private final Version minimumCompatibilityVersion;

        HandshakeRequest(Version version) {
            this.minimumCompatibilityVersion = version.minimumCompatibilityVersion();
        }

        HandshakeRequest(StreamInput streamInput) throws IOException {
            super(streamInput);
            BytesReference remainingMessage;
            try {
                remainingMessage = streamInput.readBytesReference();
            }
            catch (EOFException e) {
                remainingMessage = null;
            }
            if (remainingMessage == null) {
                this.minimumCompatibilityVersion = null;
            } else {
                try (StreamInput messageStreamInput = remainingMessage.streamInput();){
                    this.minimumCompatibilityVersion = Version.readVersion(messageStreamInput);
                }
            }
        }

        @Override
        public void writeTo(StreamOutput streamOutput) throws IOException {
            super.writeTo(streamOutput);
            assert (this.minimumCompatibilityVersion != null);
            try (BytesStreamOutput messageStreamOutput = new BytesStreamOutput(4);){
                Version.writeVersion(this.minimumCompatibilityVersion, messageStreamOutput);
                BytesReference reference = messageStreamOutput.bytes();
                streamOutput.writeBytesReference(reference);
            }
        }
    }

    static final class HandshakeResponse
    extends TransportResponse {
        private final Version responseVersion;
        private final Version responseMinimalCompatibleVersion;

        HandshakeResponse(Version version) {
            this.responseVersion = version;
            this.responseMinimalCompatibleVersion = version.minimumCompatibilityVersion();
        }

        @VisibleForTesting
        HandshakeResponse(StreamInput in) throws IOException {
            this.responseVersion = Version.readVersion(in);
            this.responseMinimalCompatibleVersion = in.getVersion();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            Version.writeVersion(this.responseVersion, out);
        }

        Version getResponseVersion() {
            return this.responseVersion;
        }

        Version responseMinimalCompatibleVersion() {
            return this.responseMinimalCompatibleVersion;
        }
    }
}

