/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.xcontent;

import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.common.xcontent.smile.SmileXContent;
import org.elasticsearch.common.xcontent.yaml.YamlXContent;

public enum XContentType {
    JSON(0){

        @Override
        public String mediaType() {
            return "application/json; charset=UTF-8";
        }

        @Override
        public String shortName() {
            return "json";
        }

        @Override
        public XContent xContent() {
            return JsonXContent.JSON_XCONTENT;
        }
    }
    ,
    SMILE(1){

        @Override
        public String mediaType() {
            return "application/smile";
        }

        @Override
        public String shortName() {
            return "smile";
        }

        @Override
        public XContent xContent() {
            return SmileXContent.SMILE_XCONTENT;
        }
    }
    ,
    YAML(2){

        @Override
        public String mediaType() {
            return "application/yaml";
        }

        @Override
        public String shortName() {
            return "yaml";
        }

        @Override
        public XContent xContent() {
            return YamlXContent.YAML_XCONTENT;
        }
    };

    private final int index;

    private XContentType(int index) {
        this.index = index;
    }

    public int index() {
        return this.index;
    }

    public abstract String mediaType();

    public abstract String shortName();

    public abstract XContent xContent();
}

