/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.parser;

import io.crate.sql.parser.AstBuilder;
import io.crate.sql.parser.CaseInsensitiveStream;
import io.crate.sql.parser.ExceptionErrorStrategy;
import io.crate.sql.parser.IdentifierSymbol;
import io.crate.sql.parser.ParsingException;
import io.crate.sql.parser.SqlParserOptions;
import io.crate.sql.parser.antlr.SqlBaseLexer;
import io.crate.sql.parser.antlr.SqlBaseParser;
import io.crate.sql.parser.antlr.SqlBaseParserBaseListener;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.MultiStatement;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.Statement;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Function;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.Pair;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;
import org.jetbrains.annotations.Nullable;

public class SqlParser {
    private static final BaseErrorListener ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String message, RecognitionException e) {
            throw new ParsingException(message, e, line, charPositionInLine);
        }
    };
    public static final SqlParser INSTANCE = new SqlParser();
    private final EnumSet<IdentifierSymbol> allowedIdentifierSymbols;

    public SqlParser() {
        this(new SqlParserOptions().allowIdentifierSymbol(IdentifierSymbol.AT_SIGN));
    }

    SqlParser(SqlParserOptions options) {
        Objects.requireNonNull(options, "options is null");
        this.allowedIdentifierSymbols = EnumSet.copyOf(options.getAllowedIdentifierSymbols());
    }

    public static Statement createStatement(String sql) {
        return INSTANCE.generateStatement(sql);
    }

    public static List<Statement> createStatementsForSimpleQuery(String sql, Function<String, Object> stringLiteralParser) {
        return ((MultiStatement)INSTANCE.invokeParser("statements", sql, SqlBaseParser::statements, str -> (Expression)INSTANCE.invokeParser("parameterOrLiteral", String.format(Locale.ENGLISH, "%s", stringLiteralParser.apply((String)str)), SqlBaseParser::parameterOrLiteral, null))).statements();
    }

    private Statement generateStatement(String sql) {
        return (Statement)this.invokeParser("statement", sql, SqlBaseParser::singleStatement, null);
    }

    public static Expression createExpression(String expression) {
        return INSTANCE.generateExpression(expression);
    }

    private Expression generateExpression(String expression) {
        return (Expression)this.invokeParser("expression", expression, SqlBaseParser::singleExpression, null);
    }

    private Node invokeParser(String name, String sql, Function<SqlBaseParser, ParserRuleContext> parseFunction, @Nullable Function<String, Expression> parseStringLiteral) {
        try {
            ParserRuleContext tree;
            SqlBaseLexer lexer = new SqlBaseLexer(new CaseInsensitiveStream((CharStream)CharStreams.fromString((String)sql, (String)name)));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            SqlBaseParser parser = new SqlBaseParser((TokenStream)tokenStream);
            parser.addParseListener(new PostProcessor());
            lexer.removeErrorListeners();
            lexer.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)ERROR_LISTENER);
            parser.setErrorHandler((ANTLRErrorStrategy)new ExceptionErrorStrategy());
            try {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
                tree = parseFunction.apply(parser);
            }
            catch (ParseCancellationException ex) {
                tokenStream.seek(0);
                parser.reset();
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL);
                tree = parseFunction.apply(parser);
            }
            return (Node)new AstBuilder(parseStringLiteral).visit((ParseTree)tree);
        }
        catch (StackOverflowError e) {
            throw new ParsingException(name + " is too large (stack overflow while parsing)");
        }
    }

    private class PostProcessor
    extends SqlBaseParserBaseListener {
        private PostProcessor() {
        }

        @Override
        public void exitUnquotedIdentifier(SqlBaseParser.UnquotedIdentifierContext context) {
            String identifier = context.IDENTIFIER().getText();
            for (IdentifierSymbol identifierSymbol : EnumSet.complementOf(SqlParser.this.allowedIdentifierSymbols)) {
                char symbol = identifierSymbol.getSymbol();
                if (identifier.indexOf(symbol) < 0) continue;
                throw new ParsingException("identifiers must not contain '" + identifierSymbol.getSymbol() + "'", null, context.IDENTIFIER().getSymbol().getLine(), context.IDENTIFIER().getSymbol().getCharPositionInLine());
            }
        }

        @Override
        public void exitBackQuotedIdentifier(SqlBaseParser.BackQuotedIdentifierContext context) {
            Token token = context.BACKQUOTED_IDENTIFIER().getSymbol();
            throw new ParsingException("backquoted identifiers are not supported; use double quotes to quote identifiers", null, token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public void exitDigitIdentifier(SqlBaseParser.DigitIdentifierContext context) {
            Token token = context.DIGIT_IDENTIFIER().getSymbol();
            throw new ParsingException("identifiers must not start with a digit; surround the identifier with double quotes", null, token.getLine(), token.getCharPositionInLine());
        }

        @Override
        public void exitNonReserved(SqlBaseParser.NonReservedContext context) {
            context.getParent().removeLastChild();
            Token token = (Token)context.getChild(0).getPayload();
            context.getParent().addChild((TerminalNode)new TerminalNodeImpl((Token)new CommonToken(new Pair((Object)token.getTokenSource(), (Object)token.getInputStream()), 325, token.getChannel(), token.getStartIndex(), token.getStopIndex())));
        }
    }
}

