/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.PartitionedBy;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import io.crate.sql.tree.TableElement;
import java.util.List;
import java.util.Optional;

public final class CreateTable<T extends Node>
extends Statement {
    private final Table<T> name;
    private final List<TableElement<T>> tableElements;
    private final Optional<PartitionedBy<T>> partitionedBy;
    private final Optional<ClusteredBy<T>> clusteredBy;
    private final boolean ifNotExists;
    private final GenericProperties<T> properties;

    public CreateTable(Table<T> name, List<TableElement<T>> tableElements, Optional<PartitionedBy<T>> partitionedBy, Optional<ClusteredBy<T>> clusteredBy, GenericProperties<T> genericProperties, boolean ifNotExists) {
        this.name = name;
        this.tableElements = tableElements;
        this.partitionedBy = partitionedBy;
        this.clusteredBy = clusteredBy;
        this.ifNotExists = ifNotExists;
        this.properties = genericProperties;
    }

    public boolean ifNotExists() {
        return this.ifNotExists;
    }

    public Table<T> name() {
        return this.name;
    }

    public List<TableElement<T>> tableElements() {
        return this.tableElements;
    }

    public Optional<ClusteredBy<T>> clusteredBy() {
        return this.clusteredBy;
    }

    public Optional<PartitionedBy<T>> partitionedBy() {
        return this.partitionedBy;
    }

    public GenericProperties<T> properties() {
        return this.properties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateTable(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateTable that = (CreateTable)o;
        if (this.ifNotExists != that.ifNotExists) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.tableElements.equals(that.tableElements)) {
            return false;
        }
        if (!this.partitionedBy.equals(that.partitionedBy)) {
            return false;
        }
        if (!this.clusteredBy.equals(that.clusteredBy)) {
            return false;
        }
        return this.properties.equals(that.properties);
    }

    @Override
    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.tableElements.hashCode();
        result = 31 * result + this.partitionedBy.hashCode();
        result = 31 * result + this.clusteredBy.hashCode();
        result = 31 * result + (this.ifNotExists ? 1 : 0);
        result = 31 * result + this.properties.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "CreateTable{name=" + String.valueOf(this.name) + ", tableElements=" + String.valueOf(this.tableElements) + ", partitionedBy=" + String.valueOf(this.partitionedBy) + ", clusteredBy=" + String.valueOf(this.clusteredBy) + ", ifNotExists=" + this.ifNotExists + ", properties=" + String.valueOf(this.properties) + "}";
    }
}

