/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.ColumnConstraint;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public final class DefaultConstraint<T>
extends ColumnConstraint<T> {
    @Nullable
    private final String name;
    private final T expression;
    private final String expressionStr;

    public DefaultConstraint(@Nullable String name, T expression, String expressionStr) {
        this.name = name;
        this.expression = expression;
        this.expressionStr = expressionStr;
    }

    @Nullable
    public String name() {
        return this.name;
    }

    public T expression() {
        return this.expression;
    }

    public String expressionStr() {
        return this.expressionStr;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDefaultConstraint(this, context);
    }

    @Override
    public <U> ColumnConstraint<U> map(Function<? super T, ? extends U> mapper) {
        return new DefaultConstraint<U>(this.name, mapper.apply(this.expression), this.expressionStr);
    }

    @Override
    public void visit(Consumer<? super T> consumer) {
        consumer.accept(this.expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof DefaultConstraint)) return false;
        DefaultConstraint that = (DefaultConstraint)o;
        if (!Objects.equals(this.name, that.name)) return false;
        if (!Objects.equals(this.expression, that.expression)) return false;
        if (!Objects.equals(this.expressionStr, that.expressionStr)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.expression, this.expressionStr);
    }

    @Override
    public String toString() {
        return "DefaultConstraint{name='" + this.name + "', expression=" + String.valueOf(this.expression) + ", expressionStr='" + this.expressionStr + "'}";
    }
}

