/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Literal;

public class DoubleLiteral
extends Literal {
    private final double value;

    public DoubleLiteral(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDoubleLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleLiteral that = (DoubleLiteral)o;
        return Double.compare(that.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        long temp = this.value != 0.0 ? Double.doubleToLongBits(this.value) : 0L;
        return (int)(temp ^ temp >>> 32);
    }
}

