/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.SetOperation;
import java.util.Objects;

public class Except
extends SetOperation {
    private final Relation left;
    private final Relation right;

    public Except(Relation left, Relation right) {
        this.left = Objects.requireNonNull(left, "relation must not be null");
        this.right = Objects.requireNonNull(right, "relation must not be null");
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitExcept(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Except except = (Except)o;
        return Objects.equals(this.left, except.left) && Objects.equals(this.right, except.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }

    @Override
    public String toString() {
        return "Except{left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + "}";
    }
}

