/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.ArrayLiteral;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.BooleanLiteral;
import io.crate.sql.tree.DoubleLiteral;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.NullLiteral;
import io.crate.sql.tree.NumericLiteral;
import io.crate.sql.tree.ObjectLiteral;
import io.crate.sql.tree.StringLiteral;
import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class Literal
extends Expression {
    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitLiteral(this, context);
    }

    public static Literal fromObject(Object value) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigDecimal.class, Double.class, Float.class, Short.class, Integer.class, Long.class, Boolean.class, Object[].class, Map.class}, (Object)object, n)) {
            case -1 -> NullLiteral.INSTANCE;
            case 0 -> {
                BigDecimal val = (BigDecimal)object;
                yield new NumericLiteral(val);
            }
            case 1 -> {
                Double val = (Double)object;
                yield new DoubleLiteral(val);
            }
            case 2 -> {
                Float val = (Float)object;
                yield new DoubleLiteral(val.doubleValue());
            }
            case 3 -> {
                Short val = (Short)object;
                yield new IntegerLiteral(val.intValue());
            }
            case 4 -> {
                Integer val = (Integer)object;
                yield new IntegerLiteral(val);
            }
            case 5 -> {
                Long val = (Long)object;
                yield new LongLiteral(val);
            }
            case 6 -> {
                Boolean val = (Boolean)object;
                if (val.booleanValue()) {
                    yield BooleanLiteral.TRUE_LITERAL;
                }
                yield BooleanLiteral.FALSE_LITERAL;
            }
            case 7 -> {
                Object[] arr = (Object[])object;
                ArrayList<Expression> expressions = new ArrayList<Expression>(arr.length);
                for (Object o : arr) {
                    expressions.add(Literal.fromObject(o));
                }
                yield new ArrayLiteral(expressions);
            }
            case 8 -> {
                Map m;
                Map valueMap = m = (Map)object;
                HashMap<String, Expression> map = HashMap.newHashMap(valueMap.size());
                for (Map.Entry entry : valueMap.entrySet()) {
                    map.put((String)entry.getKey(), Literal.fromObject(entry.getValue()));
                }
                yield new ObjectLiteral(map);
            }
            default -> new StringLiteral(value.toString());
        };
    }
}

