/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.MatchPredicateColumnIdent;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class MatchPredicate
extends Expression {
    private final List<MatchPredicateColumnIdent> idents;
    private final Expression value;
    private final GenericProperties<Expression> properties;
    private final String matchType;

    public MatchPredicate(List<MatchPredicateColumnIdent> idents, Expression value, @Nullable String matchType, GenericProperties<Expression> properties) {
        if (idents.isEmpty()) {
            throw new IllegalArgumentException("at least one ident must be given");
        }
        this.idents = idents;
        this.value = Objects.requireNonNull(value, "query_term is null");
        this.matchType = matchType;
        this.properties = properties;
    }

    public List<MatchPredicateColumnIdent> idents() {
        return this.idents;
    }

    public Expression value() {
        return this.value;
    }

    @Nullable
    public String matchType() {
        return this.matchType;
    }

    public GenericProperties<Expression> properties() {
        return this.properties;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatchPredicate that = (MatchPredicate)o;
        return Objects.equals(this.idents, that.idents) && Objects.equals(this.value, that.value) && Objects.equals(this.properties, that.properties) && Objects.equals(this.matchType, that.matchType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.idents, this.value, this.properties, this.matchType);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitMatchPredicate(this, context);
    }
}

