/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.StreamSupport;

public class QualifiedName {
    private final List<String> parts;

    public static QualifiedName of(String first, String ... rest) {
        Objects.requireNonNull(first, "first is null");
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(first);
        parts.addAll(Arrays.asList(rest));
        return new QualifiedName(parts);
    }

    public static QualifiedName of(Iterable<String> parts) {
        return new QualifiedName(parts);
    }

    public QualifiedName(String name) {
        this(List.of(name));
    }

    public QualifiedName(Iterable<String> parts) {
        List<String> partsList = StreamSupport.stream(parts.spliterator(), false).toList();
        if (partsList.isEmpty()) {
            throw new IllegalArgumentException("parts is empty");
        }
        this.parts = partsList;
    }

    public List<String> getParts() {
        return this.parts;
    }

    public String toString() {
        return Lists.joinOn((String)".", this.parts, x -> x);
    }

    public Optional<QualifiedName> getPrefix() {
        if (this.parts.size() == 1) {
            return Optional.empty();
        }
        return Optional.of(QualifiedName.of(this.parts.subList(0, this.parts.size() - 1)));
    }

    public String getSuffix() {
        return this.parts.get(this.parts.size() - 1);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return Objects.equals(this.parts, that.parts);
    }

    public int hashCode() {
        return Objects.hash(this.parts);
    }
}

