/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GroupBy;
import io.crate.sql.tree.QueryBody;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.Select;
import io.crate.sql.tree.SortItem;
import io.crate.sql.tree.Window;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class QuerySpecification
extends QueryBody {
    private final Select select;
    private final List<Relation> from;
    private final Optional<Expression> where;
    private final Optional<GroupBy> groupBy;
    private final Optional<Expression> having;
    private final List<SortItem> orderBy;
    private final Optional<Expression> limit;
    private final Optional<Expression> offset;
    private final Map<String, Window> windows;

    public QuerySpecification(Select select, List<Relation> from, Optional<Expression> where, Optional<GroupBy> groupBy, Optional<Expression> having, Map<String, Window> windows, List<SortItem> orderBy, Optional<Expression> limit, Optional<Expression> offset) {
        this.select = Objects.requireNonNull(select, "select is null");
        this.from = from;
        this.where = where;
        this.groupBy = groupBy;
        this.having = having;
        this.windows = windows;
        this.orderBy = orderBy;
        this.limit = limit;
        this.offset = offset;
    }

    public Select getSelect() {
        return this.select;
    }

    public List<Relation> getFrom() {
        return this.from;
    }

    public Optional<Expression> getWhere() {
        return this.where;
    }

    public Optional<GroupBy> getGroupBy() {
        return this.groupBy;
    }

    public Optional<Expression> getHaving() {
        return this.having;
    }

    public List<SortItem> getOrderBy() {
        return this.orderBy;
    }

    public Optional<Expression> getLimit() {
        return this.limit;
    }

    public Optional<Expression> getOffset() {
        return this.offset;
    }

    public Map<String, Window> getWindows() {
        return this.windows;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitQuerySpecification(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySpecification that = (QuerySpecification)o;
        return Objects.equals(this.select, that.select) && Objects.equals(this.from, that.from) && Objects.equals(this.where, that.where) && Objects.equals(this.groupBy, that.groupBy) && Objects.equals(this.having, that.having) && Objects.equals(this.orderBy, that.orderBy) && Objects.equals(this.limit, that.limit) && Objects.equals(this.offset, that.offset) && Objects.equals(this.windows, that.windows);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.select, this.from, this.where, this.groupBy, this.having, this.orderBy, this.limit, this.offset, this.windows);
    }

    @Override
    public String toString() {
        return "QuerySpecification{select=" + String.valueOf(this.select) + ", from=" + String.valueOf(this.from) + ", where=" + String.valueOf(this.where) + ", groupBy=" + String.valueOf(this.groupBy) + ", having=" + String.valueOf(this.having) + ", orderBy=" + String.valueOf(this.orderBy) + ", limit=" + String.valueOf(this.limit) + ", offset=" + String.valueOf(this.offset) + ", windows=" + String.valueOf(this.windows) + "}";
    }
}

