/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.SetOperation;
import java.util.Objects;

public class Union
extends SetOperation {
    private final Relation left;
    private final Relation right;
    private final boolean isDistinct;

    public Union(Relation left, Relation right, boolean isDistinct) {
        this.left = Objects.requireNonNull(left, "relation must not be null");
        this.right = Objects.requireNonNull(right, "relation must not be null");
        this.isDistinct = isDistinct;
    }

    public Relation getLeft() {
        return this.left;
    }

    public Relation getRight() {
        return this.right;
    }

    public boolean isDistinct() {
        return this.isDistinct;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitUnion(this, context);
    }

    @Override
    public String toString() {
        return "Union{left=" + String.valueOf(this.left) + ", right=" + String.valueOf(this.right) + ", isDistinct=" + this.isDistinct + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Union union = (Union)o;
        return this.isDistinct == union.isDistinct && Objects.equals(this.left, union.left) && Objects.equals(this.right, union.right);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.right, this.isDistinct);
    }
}

