/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.SortItem;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.WindowFrame;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.Nullable;

public final class Window
extends Statement {
    private final String windowRef;
    private final List<Expression> partitions;
    private final List<SortItem> orderBy;
    private final Optional<WindowFrame> windowFrame;

    public Window(@Nullable String windowRef, List<Expression> partitions, List<SortItem> orderBy, Optional<WindowFrame> windowFrame) {
        this.partitions = partitions;
        this.orderBy = orderBy;
        this.windowFrame = windowFrame;
        this.windowRef = windowRef;
    }

    @Nullable
    public String windowRef() {
        return this.windowRef;
    }

    public List<Expression> getPartitions() {
        return this.partitions;
    }

    public List<SortItem> getOrderBy() {
        return this.orderBy;
    }

    public Optional<WindowFrame> getWindowFrame() {
        return this.windowFrame;
    }

    public Window merge(Window that) {
        List<SortItem> orderBy;
        if (this.empty()) {
            return that;
        }
        if (!this.partitions.isEmpty()) {
            throw new IllegalArgumentException("Cannot override PARTITION BY clause of window " + this.windowRef);
        }
        List<Expression> partitionBy = that.getPartitions();
        if (that.getOrderBy().isEmpty()) {
            orderBy = this.getOrderBy();
        } else {
            if (!this.getOrderBy().isEmpty()) {
                throw new IllegalArgumentException("Cannot override ORDER BY clause of window " + this.windowRef);
            }
            orderBy = that.getOrderBy();
        }
        if (that.getWindowFrame().isPresent()) {
            throw new IllegalArgumentException("Cannot copy window " + this.windowRef() + " because it has a frame clause");
        }
        return new Window(that.windowRef, partitionBy, orderBy, this.getWindowFrame());
    }

    private boolean empty() {
        return this.partitions.isEmpty() && this.orderBy.isEmpty() && this.windowFrame.isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof Window)) return false;
        Window that = (Window)o;
        if (!this.partitions.equals(that.partitions)) return false;
        if (!this.orderBy.equals(that.orderBy)) return false;
        if (!this.windowFrame.equals(that.windowFrame)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.partitions.hashCode();
        result = 31 * result + this.orderBy.hashCode();
        result = 31 * result + this.windowFrame.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "Window{partitions=" + String.valueOf(this.partitions) + ", orderBy=" + String.valueOf(this.orderBy) + ", windowFrame=" + String.valueOf(this.windowFrame) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWindow(this, context);
    }
}

