/*
 * Decompiled with CFR 0.152.
 */
package io.crate.bootstrap;

import io.crate.bootstrap.BootstrapException;
import io.crate.server.cli.EnvironmentAwareCommand;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.elasticsearch.Build;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.BootstrapProxy;
import org.elasticsearch.bootstrap.StartupExceptionProxy;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.monitor.jvm.JvmInfo;
import org.elasticsearch.node.InternalSettingsPreparer;
import org.elasticsearch.node.NodeNames;
import org.elasticsearch.node.NodeValidationException;

public class CrateDB
extends EnvironmentAwareCommand {
    private final OptionSpecBuilder versionOption;

    private CrateDB() {
        super("starts CrateDB", "C", () -> {});
        this.versionOption = this.parser.acceptsAll(Arrays.asList("V", "version"), "Prints CrateDB version information and exits");
    }

    public static void main(String[] args) throws Exception {
        LogConfigurator.registerErrorListener();
        try (CrateDB crate = new CrateDB();){
            int status = crate.main(args, Terminal.DEFAULT);
            if (status != 0) {
                CrateDB.exit((int)status);
            }
        }
    }

    protected Environment createEnv(Map<String, String> cmdLineSettings) throws UserException {
        String crateHomePath = cmdLineSettings.get("path.home");
        if (crateHomePath == null) {
            throw new IllegalArgumentException("Please set the environment variable CRATE_HOME or use -Cpath.home on the command-line.");
        }
        String confPathCLI = cmdLineSettings.remove("path.conf");
        Path confPath = confPathCLI != null ? Paths.get(confPathCLI, new String[0]) : Paths.get(crateHomePath, "config");
        return InternalSettingsPreparer.prepareEnvironment((Settings)Settings.EMPTY, cmdLineSettings, (Path)confPath, NodeNames::randomNodeName);
    }

    protected void execute(Terminal terminal, OptionSet options, Environment env) throws Exception {
        if (!options.nonOptionArguments().isEmpty()) {
            throw new UserException(64, "Positional arguments not allowed, found " + String.valueOf(options.nonOptionArguments()));
        }
        if (options.has((OptionSpec)this.versionOption)) {
            terminal.println("Version: " + String.valueOf(Version.CURRENT) + ", Build: " + Build.CURRENT.hashShort() + "/" + Build.CURRENT.timestamp() + ", JVM: " + JvmInfo.jvmInfo().version());
            return;
        }
        try {
            BootstrapProxy.init(env);
        }
        catch (BootstrapException | RuntimeException e) {
            throw new StartupExceptionProxy(e);
        }
        catch (NodeValidationException e) {
            throw new UserException(78, e.getMessage());
        }
    }

    static void close(String[] args) throws IOException {
        BootstrapProxy.stop();
    }
}

