/*
 * Decompiled with CFR 0.152.
 */
package io.crate.copy.azure;

import io.crate.copy.azure.AzureBlobStorageSettings;
import io.crate.copy.azure.AzureURI;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class OperatorHelper {
    public static final List<Setting<String>> SETTINGS_TO_REWRITE = List.of(AzureBlobStorageSettings.KEY_SETTING, AzureBlobStorageSettings.SAS_TOKEN_SETTING);
    private static Map<String, String> AZURE_TO_OPEN_DAL = Map.of(AzureBlobStorageSettings.KEY_SETTING.getKey(), "account_key", AzureBlobStorageSettings.SAS_TOKEN_SETTING.getKey(), "sas_token");

    public static Map<String, String> config(AzureURI azureURI, Settings settings, boolean read) {
        AzureBlobStorageSettings.validate(settings, read);
        HashMap<String, String> config = new HashMap<String, String>();
        for (Setting<String> setting : SETTINGS_TO_REWRITE) {
            String value = (String)setting.get(settings);
            String key = setting.getKey();
            String mappedKey = AZURE_TO_OPEN_DAL.get(key);
            assert (mappedKey != null) : "All known settings must have their OpenDAL counterpart specified.";
            if (value == null) continue;
            config.put(mappedKey, value);
        }
        String endpoint = String.format(Locale.ENGLISH, "%s://%s", AzureBlobStorageSettings.PROTOCOL_SETTING.get(settings), azureURI.endpoint());
        config.put("account_name", azureURI.account());
        config.put("container", azureURI.container());
        config.put("endpoint", endpoint);
        return config;
    }
}

