/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import org.apache.datasketches.common.ArrayOfItemsSerDe;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.kll.KllDirectCompactItemsSketch;
import org.apache.datasketches.kll.KllHeapItemsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllItemsHelper;
import org.apache.datasketches.kll.KllItemsSketchIterator;
import org.apache.datasketches.kll.KllItemsSketchSortedView;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.quantilescommon.GenericPartitionBoundaries;
import org.apache.datasketches.quantilescommon.PartitioningFeature;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;
import org.apache.datasketches.quantilescommon.QuantilesGenericAPI;
import org.apache.datasketches.quantilescommon.QuantilesGenericSketchIterator;

public abstract class KllItemsSketch<T>
extends KllSketch
implements QuantilesGenericAPI<T>,
PartitioningFeature<T> {
    private KllItemsSketchSortedView<T> kllItemsSV = null;
    final Comparator<? super T> comparator;
    final ArrayOfItemsSerDe<T> serDe;

    KllItemsSketch(KllSketch.SketchStructure skStructure, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        super(KllSketch.SketchType.ITEMS_SKETCH, skStructure);
        Objects.requireNonNull(comparator, "Comparator must not be null.");
        Objects.requireNonNull(serDe, "SerDe must not be null.");
        this.comparator = comparator;
        this.serDe = serDe;
    }

    public static <T> KllItemsSketch<T> newHeapInstance(Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        KllHeapItemsSketch<? super T> itmSk = new KllHeapItemsSketch<T>(200, 8, comparator, serDe);
        return itmSk;
    }

    public static <T> KllItemsSketch<T> newHeapInstance(int k, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        return new KllHeapItemsSketch<T>(k, 8, comparator, serDe);
    }

    public static <T> KllItemsSketch<T> heapify(Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        return new KllHeapItemsSketch<T>(srcMem, comparator, serDe);
    }

    public static <T> KllItemsSketch<T> wrap(Memory srcMem, Comparator<? super T> comparator, ArrayOfItemsSerDe<T> serDe) {
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem, KllSketch.SketchType.ITEMS_SKETCH, serDe);
        return new KllDirectCompactItemsSketch<T>(memVal, comparator, serDe);
    }

    @Override
    public double[] getCDF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getCDF(splitPoints, searchCrit);
    }

    @Override
    public GenericPartitionBoundaries<T> getPartitionBoundaries(int numEquallySized, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new IllegalArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getPartitionBoundaries(numEquallySized, searchCrit);
    }

    @Override
    public double[] getPMF(T[] splitPoints, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getPMF(splitPoints, searchCrit);
    }

    @Override
    public T getQuantile(double rank, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getQuantile(rank, searchCrit);
    }

    @Override
    public T[] getQuantiles(double[] ranks, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = ranks.length;
        Object[] quantiles = (Object[])Array.newInstance(this.getMinItem().getClass(), len);
        for (int i = 0; i < len; ++i) {
            quantiles[i] = this.kllItemsSV.getQuantile(ranks[i], searchCrit);
        }
        return quantiles;
    }

    @Override
    public T getQuantileLowerBound(double rank) {
        return this.getQuantile(Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public T getQuantileUpperBound(double rank) {
        return this.getQuantile(Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    @Override
    public double getRank(T quantile, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        return this.kllItemsSV.getRank(quantile, searchCrit);
    }

    @Override
    public double getRankLowerBound(double rank) {
        return Math.max(0.0, rank - KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double getRankUpperBound(double rank) {
        return Math.min(1.0, rank + KllHelper.getNormalizedRankError(this.getMinK(), false));
    }

    @Override
    public double[] getRanks(T[] quantiles, QuantileSearchCriteria searchCrit) {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        this.refreshSortedView();
        int len = quantiles.length;
        double[] ranks = new double[len];
        for (int i = 0; i < len; ++i) {
            ranks[i] = this.kllItemsSV.getRank(quantiles[i], searchCrit);
        }
        return ranks;
    }

    @Override
    public final KllItemsSketchSortedView<T> getSortedView() {
        if (this.isEmpty()) {
            throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
        }
        return this.refreshSortedView();
    }

    @Override
    public QuantilesGenericSketchIterator<T> iterator() {
        return new KllItemsSketchIterator(this.getTotalItemsArray(), this.getLevelsArray(KllSketch.SketchStructure.UPDATABLE), this.getNumLevels());
    }

    @Override
    public final void merge(KllSketch other) {
        if (this.readOnly || this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllItemsSketch othItmSk = (KllItemsSketch)other;
        if (othItmSk.isEmpty()) {
            return;
        }
        KllItemsHelper.mergeItemImpl(this, othItmSk, this.comparator);
        this.kllItemsSV = null;
    }

    @Override
    public void reset() {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        int k = this.getK();
        this.setN(0L);
        this.setMinK(k);
        this.setNumLevels(1);
        this.setLevelZeroSorted(false);
        this.setLevelsArray(new int[]{k, k});
        this.setMinItem(null);
        this.setMaxItem(null);
        this.setItemsArray(new Object[k]);
        this.kllItemsSV = null;
    }

    public byte[] toByteArray() {
        return KllHelper.toByteArray(this, false);
    }

    @Override
    public String toString(boolean withSummary, boolean withData) {
        KllItemsSketch<T> sketch = this;
        if (withData && this.sketchStructure != KllSketch.SketchStructure.UPDATABLE) {
            WritableMemory mem = this.getWritableMemory();
            assert (mem != null);
            sketch = KllItemsSketch.heapify((Memory)this.getWritableMemory(), this.comparator, this.serDe);
        }
        return KllHelper.toStringImpl(sketch, withSummary, withData, this.getSerDe());
    }

    @Override
    public void update(T item) {
        if (this.readOnly) {
            throw new SketchesArgumentException("Target sketch is Read Only, cannot write. ");
        }
        KllItemsHelper.updateItem(this, item, this.comparator);
        this.kllItemsSV = null;
    }

    @Override
    MemoryRequestServer getMemoryRequestServer() {
        return null;
    }

    @Override
    abstract byte[] getMinMaxByteArr();

    @Override
    abstract int getMinMaxSizeBytes();

    abstract T[] getRetainedItemsArray();

    @Override
    abstract byte[] getRetainedItemsByteArr();

    @Override
    abstract int getRetainedItemsSizeBytes();

    ArrayOfItemsSerDe<T> getSerDe() {
        return this.serDe;
    }

    abstract T getSingleItem();

    @Override
    abstract byte[] getSingleItemByteArr();

    @Override
    abstract int getSingleItemSizeBytes();

    abstract T[] getTotalItemsArray();

    @Override
    byte[] getTotalItemsByteArr() {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    int getTotalItemsNumBytes() {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. ");
    }

    @Override
    void incNumLevels() {
    }

    abstract void setItemsArray(Object[] var1);

    abstract void setItemsArrayAt(int var1, Object var2);

    abstract void setMaxItem(Object var1);

    abstract void setMinItem(Object var1);

    @Override
    void setNumLevels(int numLevels) {
    }

    @Override
    void setWritableMemory(WritableMemory wmem) {
        throw new SketchesArgumentException("Unsupported operation for this Sketch Type. Sketch not writable.");
    }

    void updateMinMax(T item) {
        if (this.isEmpty()) {
            this.setMinItem(item);
            this.setMaxItem(item);
        } else {
            this.setMinItem(Util.minT(this.getMinItem(), item, this.comparator));
            this.setMaxItem(Util.maxT(this.getMaxItem(), item, this.comparator));
        }
    }

    private final KllItemsSketchSortedView<T> refreshSortedView() {
        if (this.kllItemsSV == null) {
            CreateSortedView csv = new CreateSortedView();
            this.kllItemsSV = csv.getSV();
        }
        return this.kllItemsSV;
    }

    private static <T> void blockyTandemMergeSort(Object[] quantiles, long[] weights, int[] levels, int numLevels, Comparator<? super T> comp) {
        if (numLevels == 1) {
            return;
        }
        Object[] quantilesTmp = Arrays.copyOf(quantiles, quantiles.length);
        long[] weightsTmp = Arrays.copyOf(weights, quantiles.length);
        KllItemsSketch.blockyTandemMergeSortRecursion(quantilesTmp, weightsTmp, quantiles, weights, levels, 0, numLevels, comp);
    }

    private static <T> void blockyTandemMergeSortRecursion(Object[] quantilesSrc, long[] weightsSrc, Object[] quantilesDst, long[] weightsDst, int[] levels, int startingLevel, int numLevels, Comparator<? super T> comp) {
        if (numLevels == 1) {
            return;
        }
        int numLevels1 = numLevels / 2;
        int numLevels2 = numLevels - numLevels1;
        assert (numLevels1 >= 1);
        assert (numLevels2 >= numLevels1);
        int startingLevel1 = startingLevel;
        int startingLevel2 = startingLevel + numLevels1;
        KllItemsSketch.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel1, numLevels1, comp);
        KllItemsSketch.blockyTandemMergeSortRecursion(quantilesDst, weightsDst, quantilesSrc, weightsSrc, levels, startingLevel2, numLevels2, comp);
        KllItemsSketch.tandemMerge(quantilesSrc, weightsSrc, quantilesDst, weightsDst, levels, startingLevel1, numLevels1, startingLevel2, numLevels2, comp);
    }

    private static <T> void tandemMerge(Object[] quantilesSrc, long[] weightsSrc, Object[] quantilesDst, long[] weightsDst, int[] levelStarts, int startingLevel1, int numLevels1, int startingLevel2, int numLevels2, Comparator<? super T> comp) {
        int fromIndex1 = levelStarts[startingLevel1];
        int toIndex1 = levelStarts[startingLevel1 + numLevels1];
        int fromIndex2 = levelStarts[startingLevel2];
        int toIndex2 = levelStarts[startingLevel2 + numLevels2];
        int iSrc1 = fromIndex1;
        int iSrc2 = fromIndex2;
        int iDst = fromIndex1;
        while (iSrc1 < toIndex1 && iSrc2 < toIndex2) {
            if (Util.lt(quantilesSrc[iSrc1], quantilesSrc[iSrc2], comp)) {
                quantilesDst[iDst] = quantilesSrc[iSrc1];
                weightsDst[iDst] = weightsSrc[iSrc1];
                ++iSrc1;
            } else {
                quantilesDst[iDst] = quantilesSrc[iSrc2];
                weightsDst[iDst] = weightsSrc[iSrc2];
                ++iSrc2;
            }
            ++iDst;
        }
        if (iSrc1 < toIndex1) {
            System.arraycopy(quantilesSrc, iSrc1, quantilesDst, iDst, toIndex1 - iSrc1);
            System.arraycopy(weightsSrc, iSrc1, weightsDst, iDst, toIndex1 - iSrc1);
        } else if (iSrc2 < toIndex2) {
            System.arraycopy(quantilesSrc, iSrc2, quantilesDst, iDst, toIndex2 - iSrc2);
            System.arraycopy(weightsSrc, iSrc2, weightsDst, iDst, toIndex2 - iSrc2);
        }
    }

    private final class CreateSortedView {
        T[] quantiles;
        long[] cumWeights;

        private CreateSortedView() {
        }

        KllItemsSketchSortedView<T> getSV() {
            if (KllItemsSketch.this.isEmpty()) {
                throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
            }
            if (KllItemsSketch.this.getN() == 0L) {
                throw new SketchesArgumentException("The sketch must not be empty for this operation. ");
            }
            Object[] srcQuantiles = KllItemsSketch.this.getTotalItemsArray();
            int[] srcLevels = KllItemsSketch.this.levelsArr;
            int srcNumLevels = KllItemsSketch.this.getNumLevels();
            if (!KllItemsSketch.this.isLevelZeroSorted()) {
                Arrays.sort(srcQuantiles, srcLevels[0], srcLevels[1], KllItemsSketch.this.comparator);
                if (!KllItemsSketch.this.hasMemory()) {
                    KllItemsSketch.this.setLevelZeroSorted(true);
                }
            }
            int numQuantiles = srcLevels[srcNumLevels] - srcLevels[0];
            this.quantiles = (Object[])Array.newInstance(KllItemsSketch.this.serDe.getClassOfT(), numQuantiles);
            this.cumWeights = new long[numQuantiles];
            this.populateFromSketch(srcQuantiles, srcLevels, srcNumLevels, numQuantiles);
            return new KllItemsSketchSortedView(this.quantiles, this.cumWeights, KllItemsSketch.this.getN(), KllItemsSketch.this.comparator, KllItemsSketch.this.getMaxItem(), KllItemsSketch.this.getMinItem());
        }

        private void populateFromSketch(Object[] srcQuantiles, int[] srcLevels, int srcNumLevels, int numItems) {
            int[] myLevels = new int[srcNumLevels + 1];
            int offset = srcLevels[0];
            System.arraycopy(srcQuantiles, offset, this.quantiles, 0, numItems);
            int srcLevel = 0;
            int dstLevel = 0;
            long weight = 1L;
            while (srcLevel < srcNumLevels) {
                int fromIndex = srcLevels[srcLevel] - offset;
                int toIndex = srcLevels[srcLevel + 1] - offset;
                if (fromIndex < toIndex) {
                    Arrays.fill(this.cumWeights, fromIndex, toIndex, weight);
                    myLevels[dstLevel] = fromIndex;
                    myLevels[dstLevel + 1] = toIndex;
                    ++dstLevel;
                }
                ++srcLevel;
                weight *= 2L;
            }
            int numLevels = dstLevel;
            KllItemsSketch.blockyTandemMergeSort(this.quantiles, this.cumWeights, myLevels, numLevels, KllItemsSketch.this.comparator);
            KllHelper.convertToCumulative(this.cumWeights);
        }
    }
}

