/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantilescommon;

import org.apache.datasketches.common.SketchesStateException;
import org.apache.datasketches.quantilescommon.PartitionBoundaries;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;

public final class GenericPartitionBoundaries<T>
implements PartitionBoundaries {
    private long totalN;
    private T[] boundaries;
    private long[] natRanks;
    private double[] normRanks;
    private T maxItem;
    private T minItem;
    private QuantileSearchCriteria searchCrit;
    private long[] numDeltaItems;
    private int numPartitions;

    public GenericPartitionBoundaries(long totalN, T[] boundaries, long[] natRanks, double[] normRanks, T maxItem, T minItem, QuantileSearchCriteria searchCrit) {
        this.totalN = totalN;
        this.boundaries = boundaries;
        this.natRanks = natRanks;
        this.normRanks = normRanks;
        this.maxItem = maxItem;
        this.minItem = minItem;
        this.searchCrit = searchCrit;
        int len = boundaries.length;
        if (len < 2) {
            throw new SketchesStateException("Source sketch is empty");
        }
        this.numDeltaItems = new long[len];
        this.numDeltaItems[0] = 0L;
        for (int i = 1; i < len; ++i) {
            int addOne = i == 1 && this.searchCrit == QuantileSearchCriteria.INCLUSIVE || i == len - 1 && this.searchCrit == QuantileSearchCriteria.EXCLUSIVE ? 1 : 0;
            this.numDeltaItems[i] = natRanks[i] - natRanks[i - 1] + (long)addOne;
        }
        this.numPartitions = len - 1;
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    public T[] getBoundaries() {
        return this.boundaries;
    }

    @Override
    public long[] getNaturalRanks() {
        return this.natRanks;
    }

    @Override
    public double[] getNormalizedRanks() {
        return this.normRanks;
    }

    @Override
    public long[] getNumDeltaItems() {
        return this.numDeltaItems;
    }

    @Override
    public int getNumPartitions() {
        return this.numPartitions;
    }

    public T getMaxItem() {
        return this.maxItem;
    }

    public T getMinItem() {
        return this.minItem;
    }

    @Override
    public QuantileSearchCriteria getSearchCriteria() {
        return this.searchCrit;
    }
}

