/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class AlterServer<T>
extends Statement {
    private final String name;
    private final List<Option<T>> options;

    public AlterServer(String name, List<Option<T>> options) {
        this.name = name;
        this.options = options;
    }

    public String name() {
        return this.name;
    }

    public List<Option<T>> options() {
        return this.options;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.options);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AlterServer other = (AlterServer)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.options, other.options);
    }

    @Override
    public String toString() {
        return "AlterServer{name=" + this.name + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterServer(this, context);
    }

    public record Option<T>(Operation operation, String key, @Nullable T value) {
    }

    public static enum Operation {
        ADD,
        SET,
        DROP;

    }
}

