/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Statement;
import java.util.List;
import java.util.Objects;

public class CreatePublication
extends Statement {
    private final String name;
    private final boolean forAllTables;
    private final List<QualifiedName> tables;

    public CreatePublication(String name, boolean forAllTables, List<QualifiedName> tables) {
        this.name = name;
        this.forAllTables = forAllTables;
        this.tables = tables;
    }

    public String name() {
        return this.name;
    }

    public boolean isForAllTables() {
        return this.forAllTables;
    }

    public List<QualifiedName> tables() {
        return this.tables;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreatePublication(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreatePublication that = (CreatePublication)o;
        return this.forAllTables == that.forAllTables && this.name.equals(that.name) && this.tables.equals(that.tables);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.forAllTables, this.tables);
    }

    @Override
    public String toString() {
        return "CreatePublication{name='" + this.name + "', forAllTables=" + this.forAllTables + ", tables=" + String.valueOf(this.tables) + "}";
    }
}

