/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.common.collections.Lists;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.WindowFrame;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class FrameBound
extends Node {
    private final Type type;
    @Nullable
    private final Expression value;

    public FrameBound(Type type) {
        this(type, null);
    }

    public FrameBound(Type type, @Nullable Expression value) {
        this.type = type;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    @Nullable
    public Expression getValue() {
        return this.value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof FrameBound)) return false;
        FrameBound that = (FrameBound)o;
        if (this.type != that.type) return false;
        if (!Objects.equals(this.value, that.value)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "FrameBound{type=" + String.valueOf((Object)this.type) + ", value=" + String.valueOf(this.value) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFrameBound(this, context);
    }

    public static enum Type {
        UNBOUNDED_PRECEDING{

            @Override
            public <T> int getStart(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                return pStart;
            }

            @Override
            public <T> int getEnd(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                throw new IllegalStateException("UNBOUNDED PRECEDING cannot be the start of a frame");
            }
        }
        ,
        PRECEDING{

            @Override
            public <T> int getStart(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                if (mode == WindowFrame.Mode.ROWS) {
                    assert (offset instanceof Number) : "In ROWS mode the offset must be a non-null, non-negative number";
                    return Math.max(pStart, currentRowIdx - ((Number)offset).intValue());
                }
                int firstGTEProbeValue = Lists.findFirstGTEProbeValue(rows, (int)pStart, (int)currentRowIdx, offsetProbeValue, cmp);
                if (firstGTEProbeValue == -1) {
                    return currentRowIdx;
                }
                return firstGTEProbeValue;
            }

            @Override
            public <T> int getEnd(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                throw new UnsupportedOperationException("`<offset> PRECEDING` cannot be used to calculate the end of a window frame");
            }
        }
        ,
        CURRENT_ROW{

            @Override
            public <T> int getStart(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                if (mode == WindowFrame.Mode.ROWS) {
                    return currentRowIdx;
                }
                if (pStart == currentRowIdx) {
                    return pStart;
                }
                if (cmp != null) {
                    return Math.max(pStart, Lists.findFirstPreviousPeer(rows, (int)currentRowIdx, cmp));
                }
                return currentRowIdx;
            }

            @Override
            public <T> int getEnd(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                if (mode == WindowFrame.Mode.ROWS) {
                    return currentRowIdx + 1;
                }
                return Lists.findFirstNonPeer(rows, (int)currentRowIdx, (int)pEnd, cmp);
            }
        }
        ,
        FOLLOWING{

            @Override
            public <T> int getStart(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                throw new UnsupportedOperationException("`<offset> FOLLOWING` cannot be used to calculate the start of a window frame");
            }

            @Override
            public <T> int getEnd(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                if (mode == WindowFrame.Mode.ROWS) {
                    assert (offset instanceof Number) : "In ROWS mode the offset must be a non-null, non-negative number";
                    return Math.min(pEnd, currentRowIdx + ((Number)offset).intValue() + 1);
                }
                return Lists.findFirstLTEProbeValue(rows, (int)pEnd, (int)currentRowIdx, offsetProbeValue, cmp) + 1;
            }
        }
        ,
        UNBOUNDED_FOLLOWING{

            @Override
            public <T> int getStart(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                throw new IllegalStateException("UNBOUNDED FOLLOWING cannot be the start of a frame");
            }

            @Override
            public <T> int getEnd(WindowFrame.Mode mode, int pStart, int pEnd, int currentRowIdx, @Nullable Object offset, @Nullable T offsetProbeValue, @Nullable Comparator<T> cmp, List<T> rows) {
                return pEnd;
            }
        };


        public abstract <T> int getStart(WindowFrame.Mode var1, int var2, int var3, int var4, @Nullable Object var5, @Nullable T var6, @Nullable Comparator<T> var7, List<T> var8);

        public abstract <T> int getEnd(WindowFrame.Mode var1, int var2, int var3, int var4, @Nullable Object var5, @Nullable T var6, @Nullable Comparator<T> var7, List<T> var8);
    }
}

