/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

public enum JoinType {
    CROSS,
    INNER,
    LEFT,
    RIGHT,
    FULL,
    SEMI,
    ANTI;


    public JoinType invert() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> CROSS;
            case 1 -> INNER;
            case 2 -> RIGHT;
            case 3 -> LEFT;
            case 4 -> FULL;
            case 5 -> throw new UnsupportedOperationException("SEMI Join cannot be inverted");
            case 6 -> throw new UnsupportedOperationException("ANTI Join cannot be inverted");
        };
    }

    public boolean supportsInversion() {
        return switch (this.ordinal()) {
            case 5, 6 -> false;
            default -> true;
        };
    }

    public boolean isOuter() {
        return switch (this.ordinal()) {
            case 2, 3, 4 -> true;
            default -> false;
        };
    }
}

