/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Node;
import java.util.Objects;

public class SortItem
extends Node {
    private final Expression sortKey;
    private final Ordering ordering;
    private final NullOrdering nullOrdering;

    public SortItem(Expression sortKey, Ordering ordering, NullOrdering nullOrdering) {
        this.ordering = ordering;
        this.sortKey = sortKey;
        this.nullOrdering = nullOrdering;
    }

    public Expression getSortKey() {
        return this.sortKey;
    }

    public Ordering getOrdering() {
        return this.ordering;
    }

    public NullOrdering getNullOrdering() {
        return this.nullOrdering;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSortItem(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortItem sortItem = (SortItem)o;
        return Objects.equals(this.sortKey, sortItem.sortKey) && this.ordering == sortItem.ordering && this.nullOrdering == sortItem.nullOrdering;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.sortKey, this.ordering, this.nullOrdering});
    }

    @Override
    public String toString() {
        return "SortItem{sortKey=" + String.valueOf(this.sortKey) + ", ordering=" + String.valueOf((Object)this.ordering) + ", nullOrdering=" + String.valueOf((Object)this.nullOrdering) + "}";
    }

    public static enum Ordering {
        ASCENDING,
        DESCENDING;

    }

    public static enum NullOrdering {
        FIRST,
        LAST,
        UNDEFINED;

    }
}

