/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Expression;

public class SubscriptExpression
extends Expression {
    private final Expression base;
    private final Expression index;

    public SubscriptExpression(Expression base, Expression index) {
        this.base = base;
        this.index = index;
    }

    public Expression base() {
        return this.base;
    }

    public Expression index() {
        return this.index;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitSubscriptExpression(this, context);
    }

    @Override
    public int hashCode() {
        int result = this.base.hashCode();
        result = 31 * result + this.index.hashCode();
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof SubscriptExpression)) return false;
        SubscriptExpression that = (SubscriptExpression)o;
        if (!this.index.equals(that.index)) return false;
        if (!this.base.equals(that.base)) return false;
        return true;
    }
}

