/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import java.util.Locale;
import java.util.Set;

public enum TrimMode {
    LEADING{

        @Override
        public int getTrimmedLength(String target, Set<Character> charsToTrim) {
            return target.length();
        }
    }
    ,
    TRAILING{

        @Override
        public int getStartIdx(String target, Set<Character> charsToTrim) {
            return 0;
        }
    }
    ,
    BOTH;


    public static TrimMode of(String value) {
        return TrimMode.valueOf(value.toUpperCase(Locale.ENGLISH));
    }

    public String value() {
        return this.name();
    }

    public int getStartIdx(String target, Set<Character> charsToTrim) {
        int start;
        int end = target.length();
        for (start = 0; start < end && charsToTrim.contains(Character.valueOf(target.charAt(start))); ++start) {
        }
        return start;
    }

    public int getTrimmedLength(String target, Set<Character> charsToTrim) {
        int end;
        for (end = target.length(); 0 < end && charsToTrim.contains(Character.valueOf(target.charAt(end - 1))); --end) {
        }
        return end;
    }
}

