/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nfa;

import com.oracle.truffle.regex.tregex.nfa.PureNFA;
import com.oracle.truffle.regex.tregex.nfa.PureNFAState;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransition;
import com.oracle.truffle.regex.tregex.nfa.PureNFATransitionGenerator;
import com.oracle.truffle.regex.tregex.nfa.TransitionGuard;
import com.oracle.truffle.regex.tregex.parser.Counter;
import com.oracle.truffle.regex.tregex.parser.ast.GroupBoundaries;
import com.oracle.truffle.regex.tregex.parser.ast.RegexAST;
import com.oracle.truffle.regex.tregex.parser.ast.RegexASTSubtreeRootNode;
import com.oracle.truffle.regex.tregex.parser.ast.Term;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;

public final class PureNFAGenerator {
    private final RegexAST ast;
    private final Counter.ThresholdCounter stateID = new Counter.ThresholdCounter(1000000, "PureNFA explosion");
    private final Counter.ThresholdCounter transitionID = new Counter.ThresholdCounter(1000000, "PureNFA transition explosion");
    private PureNFAState anchoredInitialState;
    private PureNFAState unAnchoredInitialState;
    private PureNFAState anchoredFinalState;
    private PureNFAState unAnchoredFinalState;
    private final Deque<PureNFAState> expansionQueue = new ArrayDeque<PureNFAState>();
    private final PureNFAState[] nfaStates;
    private final PureNFATransitionGenerator transitionGen;

    private PureNFAGenerator(RegexAST ast) {
        this.ast = ast;
        this.nfaStates = new PureNFAState[ast.getNumberOfStates()];
        this.transitionGen = new PureNFATransitionGenerator(ast, this);
        this.transitionGen.setCanTraverseCaret(true);
    }

    public static PureNFA mapToNFA(RegexAST ast) {
        ast.hidePrefix();
        PureNFAGenerator gen = new PureNFAGenerator(ast);
        PureNFA rootNFA = gen.createNFA(ast.getRoot().getSubTreeParent());
        ArrayDeque<PureNFA> subtreeExpansionQueue = new ArrayDeque<PureNFA>();
        subtreeExpansionQueue.push(rootNFA);
        while (!subtreeExpansionQueue.isEmpty()) {
            PureNFA parentNFA = (PureNFA)subtreeExpansionQueue.pop();
            RegexASTSubtreeRootNode parentRoot = parentNFA.getASTSubtree(ast);
            for (int i = 0; i < parentNFA.getSubtrees().length; ++i) {
                PureNFA childNFA = gen.createNFA((RegexASTSubtreeRootNode)parentRoot.getSubtrees().get(i));
                assert (!childNFA.isRoot());
                subtreeExpansionQueue.push(childNFA);
                parentNFA.getSubtrees()[i] = childNFA;
            }
        }
        ast.unhidePrefix();
        assert (rootNFA.getGlobalSubTreeId() == -1);
        assert (rootNFA.getSubTreeId() == -1);
        assert (rootNFA.isRoot());
        return rootNFA;
    }

    public Counter.ThresholdCounter getTransitionIdCounter() {
        return this.transitionID;
    }

    public PureNFAState getAnchoredInitialState() {
        return this.anchoredInitialState;
    }

    public PureNFAState getUnAnchoredInitialState() {
        return this.unAnchoredInitialState;
    }

    public PureNFAState getAnchoredFinalState() {
        return this.anchoredFinalState;
    }

    public PureNFAState getUnAnchoredFinalState() {
        return this.unAnchoredFinalState;
    }

    public PureNFAState getOrCreateState(Term t) {
        PureNFAState lookup = this.nfaStates[t.getId()];
        if (lookup != null) {
            return lookup;
        }
        PureNFAState state = new PureNFAState(this.stateID.inc(), t);
        this.expansionQueue.push(state);
        this.nfaStates[t.getId()] = state;
        return state;
    }

    private PureNFA createNFA(RegexASTSubtreeRootNode root) {
        PureNFAState dummyInitialState;
        assert (this.expansionQueue.isEmpty());
        Arrays.fill(this.nfaStates, null);
        this.stateID.reset();
        this.transitionID.reset();
        this.transitionGen.setReverse(root.isLookBehindAssertion());
        this.nfaStates[this.ast.getWrappedRoot().getId()] = dummyInitialState = new PureNFAState(this.stateID.inc(), this.ast.getWrappedRoot());
        assert (dummyInitialState.getId() == 0);
        if (root.isLookBehindAssertion()) {
            if (root.hasCaret()) {
                this.anchoredFinalState = this.createFinalState(root.getAnchoredInitialState(), false);
                this.anchoredFinalState.setAnchoredFinalState();
            } else {
                this.anchoredFinalState = null;
            }
            this.unAnchoredFinalState = this.createFinalState(root.getUnAnchoredInitialState(), false);
            this.unAnchoredFinalState.setUnAnchoredFinalState();
            this.unAnchoredInitialState = this.createUnAnchoredInitialState(root.getMatchFound());
            this.anchoredInitialState = root.hasDollar() ? this.createAnchoredInitialState(root.getAnchoredFinalState()) : null;
        } else {
            if (root.hasDollar()) {
                this.anchoredFinalState = this.createFinalState(root.getAnchoredFinalState(), false);
                this.anchoredFinalState.setAnchoredFinalState();
            } else {
                this.anchoredFinalState = null;
            }
            this.unAnchoredFinalState = this.createFinalState(root.getMatchFound(), false);
            this.unAnchoredFinalState.setUnAnchoredFinalState();
            this.unAnchoredInitialState = this.createUnAnchoredInitialState(root.getUnAnchoredInitialState());
            this.anchoredInitialState = root.hasCaret() ? this.createAnchoredInitialState(root.getAnchoredInitialState()) : null;
        }
        PureNFATransition initialStateTransition = this.createEmptyTransition(dummyInitialState, this.unAnchoredInitialState);
        if (this.anchoredInitialState != null) {
            dummyInitialState.setSuccessors(new PureNFATransition[]{this.createEmptyTransition(dummyInitialState, this.anchoredInitialState), initialStateTransition});
        } else {
            dummyInitialState.setSuccessors(new PureNFATransition[]{initialStateTransition, initialStateTransition});
        }
        this.expandAllStates();
        return new PureNFA(root, this.nfaStates, this.stateID, this.transitionID);
    }

    private void expandAllStates() {
        while (!this.expansionQueue.isEmpty()) {
            this.expandNFAState(this.expansionQueue.pop());
        }
    }

    private void expandNFAState(PureNFAState curState) {
        this.transitionGen.generateTransitions(curState);
    }

    private PureNFAState createAnchoredInitialState(Term astNode) {
        PureNFAState state = this.createInitialState(astNode);
        state.setAnchoredInitialState();
        return state;
    }

    private PureNFAState createUnAnchoredInitialState(Term astNode) {
        PureNFAState state = this.createInitialState(astNode);
        state.setUnAnchoredInitialState();
        return state;
    }

    private PureNFAState createInitialState(Term astNode) {
        return this.createFinalState(astNode, true);
    }

    private PureNFAState createFinalState(Term astNode, boolean enqueue) {
        PureNFAState state = new PureNFAState(this.stateID.inc(), astNode);
        assert (this.nfaStates[astNode.getId()] == null);
        this.nfaStates[astNode.getId()] = state;
        if (enqueue) {
            this.expansionQueue.add(state);
        }
        return state;
    }

    private PureNFATransition createEmptyTransition(PureNFAState src, PureNFAState tgt) {
        return new PureNFATransition(this.transitionID.inc(), src, tgt, GroupBoundaries.getEmptyInstance(this.ast.getLanguage()), false, false, TransitionGuard.NO_GUARDS);
    }
}

