/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.collections;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public final class CompoundOrdering<T>
implements Comparator<T> {
    final Comparator<? super T>[] comparators;

    public static final <T> Comparator<T> of(List<? extends Comparator<? super T>> comparators) {
        if (comparators.size() == 1) {
            return comparators.get(0);
        }
        return new CompoundOrdering<T>(comparators);
    }

    private CompoundOrdering(List<? extends Comparator<? super T>> comparators) {
        this.comparators = (Comparator[])comparators.toArray(Comparator[]::new);
    }

    @Override
    public int compare(T left, T right) {
        for (int i = 0; i < this.comparators.length; ++i) {
            int result = this.comparators[i].compare(left, right);
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof CompoundOrdering) {
            CompoundOrdering other = (CompoundOrdering)object;
            return Arrays.equals(this.comparators, other.comparators);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.comparators);
    }

    public String toString() {
        return "Ordering.compound(" + Arrays.toString(this.comparators) + ")";
    }
}

