/*
 * Decompiled with CFR 0.152.
 */
package io.crate.common.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class Exceptions {
    private static final Logger LOGGER = LogManager.getLogger(Exceptions.class);

    private Exceptions() {
    }

    public static void rethrowUnchecked(Throwable ex) {
        Exceptions.rethrow(ex);
    }

    public static Exception toException(Throwable t) {
        if (t instanceof CompletionException || t instanceof ExecutionException) {
            Throwable cause = t.getCause();
            if (cause instanceof Exception) {
                Exception ex = (Exception)cause;
                return ex;
            }
            return (Exception)t;
        }
        if (t instanceof Exception) {
            Exception e = (Exception)t;
            return e;
        }
        return new RuntimeException(t);
    }

    public static RuntimeException toRuntimeException(Throwable t) {
        if (t instanceof CompletionException || t instanceof ExecutionException) {
            t = t.getCause();
        }
        if (t instanceof RuntimeException) {
            RuntimeException re = (RuntimeException)t;
            return re;
        }
        return new RuntimeException(t);
    }

    private static <T extends Throwable> void rethrow(Throwable t) throws T {
        throw t;
    }

    public static <T extends Throwable> void rethrowAndSuppress(List<T> exceptions) throws T {
        Throwable main = null;
        for (Throwable ex : exceptions) {
            main = Exceptions.useOrSuppress(main, ex);
        }
        if (main != null) {
            throw main;
        }
    }

    public static <T extends Throwable> T useOrSuppress(@Nullable T first, T second) {
        if (first == null) {
            return second;
        }
        first.addSuppressed(second);
        return first;
    }

    public static String stackTrace(Throwable e) {
        StringWriter stackTraceStringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stackTraceStringWriter);
        e.printStackTrace(printWriter);
        return stackTraceStringWriter.toString();
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace) {
        return Arrays.stream(stackTrace).skip(1L).map(e -> "\tat " + String.valueOf(e)).collect(Collectors.joining("\n"));
    }

    @Nullable
    public static Throwable firstCause(Throwable t, Class<?> ... clazzes) {
        if (t != null) {
            Set seen = Collections.newSetFromMap(new IdentityHashMap());
            do {
                if (!seen.add(t)) {
                    return null;
                }
                for (Class<?> clazz : clazzes) {
                    if (!clazz.isInstance(t)) continue;
                    return t;
                }
            } while ((t = t.getCause()) != null);
        }
        return null;
    }

    public static <T extends Throwable> Optional<T> firstCauseOrSuppressed(Throwable t, Predicate<Throwable> predicate) {
        if (predicate.test(t)) {
            return Optional.of(t);
        }
        LinkedList<Throwable> queue = new LinkedList<Throwable>();
        queue.add(t);
        Set seen = Collections.newSetFromMap(new IdentityHashMap());
        while (!queue.isEmpty()) {
            Throwable current = (Throwable)queue.remove();
            if (!seen.add(current)) continue;
            if (predicate.test(current)) {
                return Optional.of(current);
            }
            Collections.addAll(queue, current.getSuppressed());
            if (current.getCause() == null) continue;
            queue.add(current.getCause());
        }
        return Optional.empty();
    }

    public static Optional<Error> maybeError(Throwable cause) {
        return Exceptions.firstCauseOrSuppressed(cause, t -> t instanceof Error);
    }

    public static void maybeDieOnAnotherThread(Throwable throwable) {
        Exceptions.maybeError(throwable).ifPresent(error -> {
            try {
                String formatted = Exceptions.formatStackTrace(Thread.currentThread().getStackTrace());
                LOGGER.error("fatal error\n{}", (Object)formatted);
            }
            finally {
                new Thread(() -> {
                    throw error;
                }).start();
            }
        });
    }

    public static String userFriendlyMessageInclNested(Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        if (t.getCause() != null) {
            StringBuilder sb = new StringBuilder();
            while (t != null) {
                sb.append(t.getClass().getSimpleName());
                if (t.getMessage() != null) {
                    sb.append("[");
                    sb.append(t.getMessage());
                    sb.append("]");
                }
                sb.append("; ");
                if ((t = t.getCause()) == null) continue;
                sb.append("nested: ");
            }
            return sb.toString();
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }

    public static String userFriendlyMessage(Throwable t) {
        if (t == null) {
            return "Unknown";
        }
        return t.getClass().getSimpleName() + "[" + t.getMessage() + "]";
    }
}

