/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.DDLStatement;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.AlterTable;
import io.crate.sql.tree.Assignment;
import java.util.function.Consumer;

public class AnalyzedAlterTable
implements DDLStatement {
    private final TableInfo tableInfo;
    private final AlterTable<Symbol> alterTable;

    public AnalyzedAlterTable(TableInfo tableInfo, AlterTable<Symbol> alterTable) {
        this.tableInfo = tableInfo;
        this.alterTable = alterTable;
    }

    public TableInfo tableInfo() {
        return this.tableInfo;
    }

    public AlterTable<Symbol> alterTable() {
        return this.alterTable;
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Assignment partitionProperty : this.alterTable.table().partitionProperties()) {
            consumer.accept((Symbol)partitionProperty.expression());
            partitionProperty.expressions().forEach(consumer);
        }
        this.alterTable.genericProperties().forValues(consumer);
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> visitor, C context) {
        return visitor.visitAlterTable(this, context);
    }
}

