/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.table.TableInfo;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class AnalyzedCopyTo
implements AnalyzedStatement {
    private final TableInfo tableInfo;
    private final Table<Symbol> table;
    private final Symbol uri;
    private final GenericProperties<Symbol> properties;
    private final List<Symbol> columns;
    @Nullable
    private final Symbol whereClause;

    AnalyzedCopyTo(TableInfo tableInfo, Table<Symbol> table, Symbol uri, GenericProperties<Symbol> properties, List<Symbol> columns, @Nullable Symbol whereClause) {
        this.tableInfo = tableInfo;
        this.table = table;
        this.uri = uri;
        this.properties = properties;
        this.columns = columns;
        this.whereClause = whereClause;
    }

    public TableInfo tableInfo() {
        return this.tableInfo;
    }

    public Table<Symbol> table() {
        return this.table;
    }

    public Symbol uri() {
        return this.uri;
    }

    public GenericProperties<Symbol> properties() {
        return this.properties;
    }

    public List<Symbol> columns() {
        return this.columns;
    }

    @Nullable
    public Symbol whereClause() {
        return this.whereClause;
    }

    @Override
    public <C, R> R accept(AnalyzedStatementVisitor<C, R> analyzedStatementVisitor, C context) {
        return analyzedStatementVisitor.visitCopyToStatement(this, context);
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        for (Assignment partitionProperty : this.table.partitionProperties()) {
            consumer.accept((Symbol)partitionProperty.columnName());
            partitionProperty.expressions().forEach(consumer);
        }
        this.columns.forEach(consumer);
        if (this.whereClause != null) {
            consumer.accept(this.whereClause);
        }
        consumer.accept(this.uri);
        this.properties.forValues(consumer);
    }

    @Override
    public boolean isWriteOperation() {
        return false;
    }
}

