/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedDeallocate;
import io.crate.sql.tree.DeallocateStatement;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.StringLiteral;

public final class DeallocateAnalyzer {
    private DeallocateAnalyzer() {
    }

    public static AnalyzedDeallocate analyze(DeallocateStatement deallocateStatement) {
        Expression preparedStmtExpression = deallocateStatement.preparedStmt();
        String preparedStmt = null;
        if (preparedStmtExpression != null) {
            if (preparedStmtExpression instanceof StringLiteral) {
                preparedStmt = ((StringLiteral)preparedStmtExpression).getValue();
            } else if (preparedStmtExpression instanceof QualifiedNameReference) {
                preparedStmt = ((QualifiedNameReference)preparedStmtExpression).getName().toString();
            } else {
                throw new AssertionError((Object)("Expression " + preparedStmtExpression.toString() + " not supported as preparedStmt expression for DEALLOCATE"));
            }
        }
        return new AnalyzedDeallocate(preparedStmt);
    }
}

