/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.Analysis;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.Analyzer;
import io.crate.analyze.ExplainAnalyzedStatement;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.planner.node.management.ExplainPlan;
import io.crate.profile.ProfilingContext;
import io.crate.profile.Timer;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.Explain;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.Statement;
import java.util.EnumSet;
import java.util.Map;

public class ExplainStatementAnalyzer {
    private static final EnumSet<Explain.Option> ONLY_COSTS = EnumSet.of(Explain.Option.COSTS);
    private static final EnumSet<Explain.Option> ONLY_ANALYZE = EnumSet.of(Explain.Option.ANALYZE);
    private final Analyzer analyzer;
    private static final AstVisitor<Void, Void> EXPLAIN_CHECK_VISITOR = new AstVisitor<Void, Void>(){

        protected Void visitQuery(Query node, Void context) {
            return null;
        }

        public Void visitCopyFrom(CopyFrom<?> node, Void context) {
            return null;
        }

        public Void visitInsert(Insert<?> node, Void context) {
            return (Void)node.insertSource().accept((AstVisitor)this, (Object)context);
        }

        protected Void visitNode(Node node, Void context) {
            throw new UnsupportedFeatureException("EXPLAIN is not supported for " + String.valueOf(node));
        }
    };
    private static final AstVisitor<Void, Void> EXPLAIN_VERBOSE_CHECK_VISITOR = new AstVisitor<Void, Void>(){

        protected Void visitQuery(Query node, Void context) {
            return null;
        }

        protected Void visitNode(Node node, Void context) {
            throw new UnsupportedFeatureException("EXPLAIN VERBOSE is not supported for " + String.valueOf(node));
        }
    };
    private static final AstVisitor<Void, Void> EXPLAIN_ANALYZE_CHECK_VISITOR = new AstVisitor<Void, Void>(){

        protected Void visitQuery(Query node, Void context) {
            return null;
        }

        protected Void visitNode(Node node, Void context) {
            throw new UnsupportedFeatureException("EXPLAIN ANALYZE is not supported for " + String.valueOf(node));
        }
    };

    ExplainStatementAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
    }

    public ExplainAnalyzedStatement analyze(Explain node, Analysis analysis) {
        boolean isVerboseActivated = node.isOptionActivated(Explain.Option.VERBOSE);
        boolean isAnalyzeActivated = node.isOptionActivated(Explain.Option.ANALYZE);
        Statement statement = node.getStatement();
        statement.accept(isVerboseActivated ? EXPLAIN_VERBOSE_CHECK_VISITOR : (isAnalyzeActivated ? EXPLAIN_ANALYZE_CHECK_VISITOR : EXPLAIN_CHECK_VISITOR), null);
        if (node.options().isEmpty()) {
            return new ExplainAnalyzedStatement(this.analyzer.analyzedStatement(statement, analysis), null, ONLY_COSTS);
        }
        boolean isCostsActivated = node.isOptionActivated(Explain.Option.COSTS);
        if (isCostsActivated && isAnalyzeActivated) {
            throw new IllegalArgumentException("The ANALYZE and COSTS options are not allowed together");
        }
        if (isAnalyzeActivated && isVerboseActivated) {
            throw new IllegalArgumentException("The ANALYZE and VERBOSE options are not allowed together");
        }
        if (isAnalyzeActivated) {
            ProfilingContext profilingContext = new ProfilingContext(Map.of());
            Timer timer = profilingContext.createAndStartTimer(ExplainPlan.Phase.Analyze.name());
            AnalyzedStatement subStatement = this.analyzer.analyzedStatement(statement, analysis);
            profilingContext.stopTimerAndStoreDuration(timer);
            return new ExplainAnalyzedStatement(subStatement, profilingContext, ONLY_ANALYZE);
        }
        EnumSet<Explain.Option> explainOptions = EnumSet.noneOf(Explain.Option.class);
        if (!node.isOptionExplicitlyDeactivated(Explain.Option.COSTS)) {
            explainOptions.add(Explain.Option.COSTS);
        }
        if (isVerboseActivated) {
            explainOptions.add(Explain.Option.VERBOSE);
        }
        return new ExplainAnalyzedStatement(this.analyzer.analyzedStatement(statement, analysis), null, explainOptions);
    }
}

