/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedRefreshTable;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.table.Operation;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.RefreshStatement;
import io.crate.sql.tree.Table;
import java.util.HashMap;

class RefreshTableAnalyzer {
    private final NodeContext nodeCtx;
    private final Schemas schemas;

    RefreshTableAnalyzer(NodeContext nodeCtx, Schemas schemas) {
        this.nodeCtx = nodeCtx;
        this.schemas = schemas;
    }

    public AnalyzedRefreshTable analyze(RefreshStatement<Expression> refreshStatement, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnCtx) {
        ExpressionAnalyzer exprAnalyzerWithFieldsAsString = new ExpressionAnalyzer(txnCtx, this.nodeCtx, paramTypeHints, FieldProvider.TO_LITERAL_VALIDATE_NAME, null);
        ExpressionAnalysisContext exprCtx = new ExpressionAnalysisContext(txnCtx.sessionSettings());
        HashMap<Table<Symbol>, DocTableInfo> analyzedTables = new HashMap<Table<Symbol>, DocTableInfo>();
        for (Table table : refreshStatement.tables()) {
            Table analyzedTable = table.map(t -> exprAnalyzerWithFieldsAsString.convert((Expression)t, exprCtx));
            DocTableInfo tableInfo = (DocTableInfo)this.schemas.findRelation(table.getName(), Operation.REFRESH, txnCtx.sessionSettings().sessionUser(), txnCtx.sessionSettings().searchPath());
            analyzedTables.put((Table<Symbol>)analyzedTable, tableInfo);
        }
        return new AnalyzedRefreshTable(analyzedTables);
    }
}

