/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze;

import io.crate.analyze.AnalyzedAlterRole;
import io.crate.analyze.AnalyzedCreateRole;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.relations.FieldProvider;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.sql.tree.AlterRoleReset;
import io.crate.sql.tree.AlterRoleSet;
import io.crate.sql.tree.CreateRole;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.GenericProperties;
import java.util.Map;
import java.util.Set;

public class RoleAnalyzer {
    private final NodeContext nodeCtx;

    RoleAnalyzer(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedCreateRole analyze(CreateRole node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnContext) {
        GenericProperties<Symbol> properties = this.mappedProperties((GenericProperties<Expression>)node.properties(), paramTypeHints, txnContext);
        properties.ensureContainsOnly(Set.of("password", "jwt"));
        return new AnalyzedCreateRole(node.name(), node.isUser(), properties);
    }

    public AnalyzedAlterRole analyze(AlterRoleSet<Expression> node, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnContext) {
        GenericProperties<Symbol> properties = this.mappedProperties((GenericProperties<Expression>)node.properties(), paramTypeHints, txnContext);
        return new AnalyzedAlterRole(node.name(), properties, false);
    }

    public AnalyzedAlterRole analyze(AlterRoleReset node) {
        if (node.property() == null) {
            return new AnalyzedAlterRole(node.name(), (GenericProperties<Symbol>)new GenericProperties(Map.of()), true);
        }
        return new AnalyzedAlterRole(node.name(), (GenericProperties<Symbol>)new GenericProperties(Map.of(node.property(), Literal.NULL)), true);
    }

    private GenericProperties<Symbol> mappedProperties(GenericProperties<Expression> properties, ParamTypeHints paramTypeHints, CoordinatorTxnCtx txnContext) {
        ExpressionAnalysisContext exprContext = new ExpressionAnalysisContext(txnContext.sessionSettings());
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(txnContext, this.nodeCtx, paramTypeHints, FieldProvider.UNSUPPORTED, null);
        return properties.map(x -> expressionAnalyzer.convert((Expression)x, exprContext));
    }
}

