/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.FieldResolver;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.VoidReference;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.role.Role;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnalyzedView
implements AnalyzedRelation,
FieldResolver {
    private final RelationName name;
    private final Role owner;
    private final AnalyzedRelation relation;
    private final List<Symbol> outputSymbols;

    public AnalyzedView(RelationName name, Role owner, AnalyzedRelation relation) {
        this.name = name;
        this.owner = owner;
        this.relation = relation;
        List<Symbol> childOutputs = relation.outputs();
        ArrayList<ScopedSymbol> outputs = new ArrayList<ScopedSymbol>(childOutputs.size());
        for (int i = 0; i < childOutputs.size(); ++i) {
            Symbol output = childOutputs.get(i);
            ColumnIdent column = output.toColumn();
            outputs.add(new ScopedSymbol(name, column, output));
        }
        this.outputSymbols = List.copyOf(outputs);
    }

    @NotNull
    public Role owner() {
        return this.owner;
    }

    public AnalyzedRelation relation() {
        return this.relation;
    }

    public RelationName name() {
        return this.name;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitView(this, context);
    }

    @Override
    public void visitSymbols(Consumer<? super Symbol> consumer) {
        this.relation.visitSymbols(consumer);
    }

    @Override
    public Symbol getField(ColumnIdent column, Operation operation, boolean errorOnUnknownObjectKey) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        Symbol field = this.relation.getField(column, operation, errorOnUnknownObjectKey);
        if (field == null || field instanceof VoidReference) {
            return field;
        }
        ScopedSymbol scopedSymbol = new ScopedSymbol(this.name, column, field);
        int i = this.outputSymbols.indexOf(scopedSymbol);
        if (i >= 0) {
            return this.outputSymbols.get(i);
        }
        return scopedSymbol;
    }

    @Override
    public RelationName relationName() {
        return this.name;
    }

    @Override
    @NotNull
    public List<Symbol> outputs() {
        return this.outputSymbols;
    }

    public String toString() {
        return "AnalyzedView{qualifiedName=" + String.valueOf(this.name) + ", relation=" + String.valueOf(this.relation) + "}";
    }

    @Override
    @Nullable
    public Symbol resolveField(ScopedSymbol field) {
        if (!field.relation().equals(this.name)) {
            throw new IllegalArgumentException(String.valueOf(field) + " does not belong to " + String.valueOf(this.name));
        }
        return this.relation.getField(field.column(), Operation.READ);
    }
}

