/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.exceptions.AmbiguousColumnException;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.table.Operation;
import io.crate.planner.operators.LogicalPlan;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlannedRelation
implements AnalyzedRelation {
    private final LogicalPlan source;

    public PlannedRelation(LogicalPlan source) {
        this.source = source;
    }

    @Override
    public <C, R> R accept(AnalyzedRelationVisitor<C, R> visitor, C context) {
        return visitor.visitPlannedRelation(this, context);
    }

    @Override
    @Nullable
    public Symbol getField(ColumnIdent column, Operation operation, boolean errorOnUnknownObjectKey) throws AmbiguousColumnException, ColumnUnknownException, UnsupportedOperationException {
        throw new UnsupportedOperationException("Not supported on PlannedRelation");
    }

    @Override
    public RelationName relationName() {
        return this.source.relationNames().getFirst();
    }

    @Override
    @NotNull
    public List<Symbol> outputs() {
        return this.source.outputs();
    }

    public String toString() {
        return this.relationName().fqn();
    }
}

