/*
 * Decompiled with CFR 0.152.
 */
package io.crate.analyze.relations;

import io.crate.analyze.JoinRelation;
import io.crate.analyze.OrderBy;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.RelationNames;
import io.crate.analyze.expressions.ExpressionAnalysisContext;
import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.analyze.expressions.SubqueryAnalyzer;
import io.crate.analyze.relations.AliasedAnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedView;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.FieldProvider;
import io.crate.analyze.relations.FullQualifiedNameFieldProvider;
import io.crate.analyze.relations.JoinPair;
import io.crate.analyze.relations.OrderyByAnalyzer;
import io.crate.analyze.relations.RelationAnalysisContext;
import io.crate.analyze.relations.SelectListFieldProvider;
import io.crate.analyze.relations.StatementAnalysisContext;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.analyze.relations.TableRelation;
import io.crate.analyze.relations.UnionSelect;
import io.crate.analyze.relations.select.SelectAnalysis;
import io.crate.analyze.relations.select.SelectAnalyzer;
import io.crate.analyze.validator.GroupBySymbolValidator;
import io.crate.analyze.validator.HavingSymbolValidator;
import io.crate.analyze.validator.SemanticSortValidator;
import io.crate.analyze.where.WhereClauseValidator;
import io.crate.common.collections.Iterables;
import io.crate.common.collections.Lists;
import io.crate.exceptions.ColumnUnknownException;
import io.crate.exceptions.RelationUnknown;
import io.crate.exceptions.RelationValidationException;
import io.crate.exceptions.UnauthorizedException;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.scalar.arithmetic.ArrayFunction;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.GroupAndAggregateSemantics;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.tablefunctions.TableFunctionFactory;
import io.crate.expression.tablefunctions.ValuesFunction;
import io.crate.fdw.ForeignTable;
import io.crate.fdw.ForeignTableRelation;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.FunctionType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.SearchPath;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.Operation;
import io.crate.metadata.table.TableInfo;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.metadata.view.ViewInfo;
import io.crate.planner.consumer.OrderByWithAggregationValidator;
import io.crate.role.Role;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.AliasedRelation;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.DefaultTraversalVisitor;
import io.crate.sql.tree.Except;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.FunctionCall;
import io.crate.sql.tree.GroupBy;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.Intersect;
import io.crate.sql.tree.Join;
import io.crate.sql.tree.JoinCriteria;
import io.crate.sql.tree.JoinOn;
import io.crate.sql.tree.JoinUsing;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.QualifiedNameReference;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.QuerySpecification;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.SortItem;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import io.crate.sql.tree.TableFunction;
import io.crate.sql.tree.TableSubquery;
import io.crate.sql.tree.Union;
import io.crate.sql.tree.Values;
import io.crate.sql.tree.ValuesList;
import io.crate.sql.tree.With;
import io.crate.sql.tree.WithQuery;
import io.crate.types.ArrayType;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.RowType;
import io.crate.types.UndefinedType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SequencedSet;
import java.util.function.Function;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.jetbrains.annotations.Nullable;

@Singleton
public class RelationAnalyzer
extends DefaultTraversalVisitor<AnalyzedRelation, StatementAnalysisContext> {
    private final NodeContext nodeCtx;
    private static final List<Relation> EMPTY_ROW_TABLE_RELATION = List.of(new TableFunction(new FunctionCall(QualifiedName.of((String)"empty_row", (String[])new String[0]), Collections.emptyList())));

    @Inject
    public RelationAnalyzer(NodeContext nodeCtx) {
        this.nodeCtx = nodeCtx;
    }

    public AnalyzedRelation analyze(Node node, StatementAnalysisContext statementContext) {
        return (AnalyzedRelation)node.accept((AstVisitor)this, (Object)statementContext);
    }

    public AnalyzedRelation analyze(Query query, CoordinatorTxnCtx coordinatorTxnCtx, ParamTypeHints paramTypeHints) {
        return this.analyze((Node)query, new StatementAnalysisContext(paramTypeHints, Operation.READ, coordinatorTxnCtx));
    }

    protected AnalyzedRelation visitQuery(Query node, StatementAnalysisContext statementContext) {
        statementContext.startRelation();
        if (node.getWith().isPresent()) {
            With with = (With)node.getWith().get();
            with.withQueries().forEach(wq -> wq.accept((AstVisitor)this, (Object)statementContext));
        }
        AnalyzedRelation childRelation = (AnalyzedRelation)node.getQueryBody().accept((AstVisitor)this, (Object)statementContext);
        statementContext.endRelation();
        if (node.getOrderBy().isEmpty() && node.getLimit().isEmpty() && node.getOffset().isEmpty()) {
            return childRelation;
        }
        statementContext.startRelation();
        RelationAnalysisContext relationAnalysisContext = statementContext.currentRelationContext();
        relationAnalysisContext.addSourceRelation(childRelation);
        statementContext.endRelation();
        List<Symbol> childRelationFields = childRelation.outputs();
        CoordinatorTxnCtx coordinatorTxnCtx = statementContext.transactionContext();
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(coordinatorTxnCtx, this.nodeCtx, statementContext.paramTyeHints(), new FullQualifiedNameFieldProvider(relationAnalysisContext.sources(), relationAnalysisContext.parentSources(), coordinatorTxnCtx.sessionSettings().searchPath().currentSchema()), new SubqueryAnalyzer(this, statementContext));
        ExpressionAnalysisContext expressionAnalysisContext = relationAnalysisContext.expressionAnalysisContext();
        SelectAnalysis selectAnalysis = new SelectAnalysis(childRelationFields.size(), relationAnalysisContext.sources(), expressionAnalyzer, expressionAnalysisContext);
        for (Symbol field : childRelationFields) {
            selectAnalysis.add(field.toColumn(), field);
        }
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(this.nodeCtx, f -> expressionAnalysisContext.isEagerNormalizationAllowed() && f.signature().isDeterministic());
        return new QueriedSelectRelation(false, List.of(childRelation), List.of(), selectAnalysis.outputSymbols(), Literal.BOOLEAN_TRUE, List.of(), null, RelationAnalyzer.analyzeOrderBy(selectAnalysis, node.getOrderBy(), expressionAnalyzer, expressionAnalysisContext, false, false), RelationAnalyzer.longSymbolOrNull(node.getLimit(), expressionAnalyzer, expressionAnalysisContext, normalizer, coordinatorTxnCtx), RelationAnalyzer.longSymbolOrNull(node.getOffset(), expressionAnalyzer, expressionAnalysisContext, normalizer, coordinatorTxnCtx));
    }

    protected AnalyzedRelation visitUnion(Union node, StatementAnalysisContext context) {
        AnalyzedRelation left = (AnalyzedRelation)node.getLeft().accept((AstVisitor)this, (Object)context);
        AnalyzedRelation right = (AnalyzedRelation)node.getRight().accept((AstVisitor)this, (Object)context);
        return new UnionSelect(left, right, node.isDistinct());
    }

    protected AnalyzedRelation visitIntersect(Intersect node, StatementAnalysisContext context) {
        throw new UnsupportedFeatureException("INTERSECT is not supported");
    }

    protected AnalyzedRelation visitExcept(Except node, StatementAnalysisContext context) {
        throw new UnsupportedFeatureException("EXCEPT is not supported");
    }

    protected AnalyzedRelation visitJoin(Join node, StatementAnalysisContext statementContext) {
        AnalyzedRelation leftRel = (AnalyzedRelation)node.getLeft().accept((AstVisitor)this, (Object)statementContext);
        AnalyzedRelation rightRel = (AnalyzedRelation)node.getRight().accept((AstVisitor)this, (Object)statementContext);
        Optional optCriteria = node.getCriteria();
        Symbol joinCondition = null;
        if (optCriteria.isPresent()) {
            Expression expression;
            JoinCriteria joinCriteria = (JoinCriteria)optCriteria.get();
            if (joinCriteria instanceof JoinOn) {
                JoinOn joinOn = (JoinOn)joinCriteria;
                expression = joinOn.getExpression();
            } else if (joinCriteria instanceof JoinUsing) {
                JoinUsing joinUsing = (JoinUsing)joinCriteria;
                expression = RelationAnalyzer.validateAndExtractFromUsing(leftRel.outputs(), rightRel.outputs(), joinUsing);
            } else {
                throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "join criteria %s not supported", joinCriteria.getClass().getSimpleName()));
            }
            try {
                RelationAnalysisContext relationContext = statementContext.currentRelationContext();
                CoordinatorTxnCtx coordinatorTxnCtx = statementContext.transactionContext();
                ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(coordinatorTxnCtx, this.nodeCtx, statementContext.paramTyeHints(), new FullQualifiedNameFieldProvider(relationContext.sources(), relationContext.parentSources(), coordinatorTxnCtx.sessionSettings().searchPath().currentSchema()), new SubqueryAnalyzer(this, statementContext));
                ExpressionAnalysisContext expressionAnalysisContext = statementContext.currentRelationContext().expressionAnalysisContext();
                joinCondition = expressionAnalyzer.convert(expression, expressionAnalysisContext);
            }
            catch (RelationUnknown e) {
                throw new RelationValidationException(e.getTableIdents(), String.format(Locale.ENGLISH, "missing FROM-clause entry for relation '%s'", e.getTableIdents()));
            }
        }
        JoinRelation joinRelation = new JoinRelation(leftRel, rightRel, node.getType(), joinCondition);
        JoinPair joinPair = RelationAnalyzer.extractJoinPair(joinRelation, statementContext.currentRelationContext().sourceNames());
        statementContext.currentRelationContext().addJoinPair(joinPair);
        return joinRelation;
    }

    private static JoinPair extractJoinPair(JoinRelation joinRelation, List<RelationName> relevantRelationsInOrder) {
        SequencedSet<RelationName> relationsInJoinConditions;
        assert (relevantRelationsInOrder.size() >= 2) : "sources must be added first, cannot add join pair for only 1 source";
        Symbol joinCondition = joinRelation.joinCondition();
        if (joinCondition != null && (relationsInJoinConditions = RelationNames.getShallow(joinCondition)).size() > 1) {
            relevantRelationsInOrder.retainAll(relationsInJoinConditions);
        }
        RelationName left = relevantRelationsInOrder.get(relevantRelationsInOrder.size() - 2);
        RelationName right = relevantRelationsInOrder.get(relevantRelationsInOrder.size() - 1);
        return JoinPair.of(left, right, joinRelation.joinType(), joinCondition);
    }

    private static Expression validateAndExtractFromUsing(List<Symbol> leftOutputs, List<Symbol> rightOutputs, JoinUsing joinUsing) {
        HashMap<String, Symbol> lhsOutputs = new HashMap<String, Symbol>();
        HashMap<String, Symbol> rhsOutputs = new HashMap<String, Symbol>();
        for (String joinColumn : joinUsing.getColumns()) {
            boolean joinColumnExistsInLeft = false;
            for (Symbol leftOutput : leftOutputs) {
                ColumnIdent columnIdent = leftOutput.toColumn();
                if (!columnIdent.name().equals(joinColumn)) continue;
                joinColumnExistsInLeft = true;
                if (lhsOutputs.put(joinColumn, leftOutput) == null) continue;
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "common column name %s appears more than once in left table", joinColumn));
            }
            if (!joinColumnExistsInLeft) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "column %s specified in USING clause does not exist in left table", joinColumn));
            }
            boolean joinColumnExistsInRight = false;
            for (Symbol rightOutput : rightOutputs) {
                DataType<?> rhsType;
                ColumnIdent columnIdent = rightOutput.toColumn();
                if (!columnIdent.name().equals(joinColumn)) continue;
                joinColumnExistsInRight = true;
                if (rhsOutputs.put(joinColumn, rightOutput) != null) {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "common column name %s appears more than once in right table", joinColumn));
                }
                DataType<?> lhsType = ((Symbol)lhsOutputs.get(joinColumn)).valueType();
                if (lhsType.equals(rhsType = rightOutput.valueType())) continue;
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "JOIN/USING types %s and %s varying cannot be matched", lhsType.getName(), rhsType.getName()));
            }
            if (joinColumnExistsInRight) continue;
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "column %s specified in USING clause does not exist in right table", joinColumn));
        }
        HashSet<RelationName> lhsRelationNames = new HashSet<RelationName>();
        HashSet<RelationName> rhsRelationNames = new HashSet<RelationName>();
        for (Symbol symbol : lhsOutputs.values()) {
            lhsRelationNames.addAll(RelationNames.getShallow(symbol));
        }
        for (Symbol symbol : rhsOutputs.values()) {
            rhsRelationNames.addAll(RelationNames.getShallow(symbol));
        }
        return JoinUsing.toExpression((QualifiedName)((RelationName)Iterables.getOnlyElement(lhsRelationNames)).toQualifiedName(), (QualifiedName)((RelationName)Iterables.getOnlyElement(rhsRelationNames)).toQualifiedName(), (List)joinUsing.getColumns());
    }

    protected AnalyzedRelation visitQuerySpecification(QuerySpecification node, StatementAnalysisContext statementContext) {
        List from = node.getFrom().isEmpty() ? EMPTY_ROW_TABLE_RELATION : node.getFrom();
        RelationAnalysisContext currentRelationContext = statementContext.startRelation();
        for (Relation relation : from) {
            RelationAnalysisContext innerContext = statementContext.startRelation();
            relation.accept((AstVisitor)this, (Object)statementContext);
            statementContext.endRelation();
            for (Map.Entry<RelationName, AnalyzedRelation> entry : innerContext.sources().entrySet()) {
                currentRelationContext.addSourceRelation(entry.getValue());
            }
            for (JoinPair joinPair : innerContext.joinPairs()) {
                currentRelationContext.addJoinPair(joinPair);
            }
        }
        RelationAnalysisContext context = statementContext.currentRelationContext();
        CoordinatorTxnCtx coordinatorTxnCtx = statementContext.transactionContext();
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(coordinatorTxnCtx, this.nodeCtx, statementContext.paramTyeHints(), new FullQualifiedNameFieldProvider(context.sources(), context.parentSources(), coordinatorTxnCtx.sessionSettings().searchPath().currentSchema()), new SubqueryAnalyzer(this, statementContext));
        ExpressionAnalysisContext expressionAnalysisContext = context.expressionAnalysisContext();
        expressionAnalysisContext.windows(node.getWindows());
        SelectAnalysis selectAnalysis = SelectAnalyzer.analyzeSelectItems(node.getSelect().getSelectItems(), context.sources(), expressionAnalyzer, expressionAnalysisContext);
        List<Symbol> groupBy = this.analyzeGroupBy(selectAnalysis, node.getGroupBy().map(GroupBy::getExpressions).orElse(List.of()), expressionAnalyzer, expressionAnalysisContext, node.getGroupBy().map(GroupBy::isAll).orElse(false));
        if (!node.getGroupBy().isEmpty() || expressionAnalysisContext.hasAggregates()) {
            GroupAndAggregateSemantics.validate(selectAnalysis.outputSymbols(), groupBy);
        }
        boolean isDistinct = node.getSelect().isDistinct();
        Symbol where = expressionAnalyzer.generateQuerySymbol(node.getWhere(), expressionAnalysisContext);
        WhereClauseValidator.validate(where);
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(this.nodeCtx, f -> expressionAnalysisContext.isEagerNormalizationAllowed() && f.signature().isDeterministic());
        QueriedSelectRelation relation = new QueriedSelectRelation(isDistinct, List.copyOf(context.sources().values()), context.joinPairs(), selectAnalysis.outputSymbols(), where, groupBy, this.analyzeHaving(node.getHaving(), groupBy, expressionAnalyzer, context.expressionAnalysisContext()), RelationAnalyzer.analyzeOrderBy(selectAnalysis, node.getOrderBy(), expressionAnalyzer, expressionAnalysisContext, expressionAnalysisContext.hasAggregates() || !groupBy.isEmpty(), isDistinct), RelationAnalyzer.longSymbolOrNull(node.getLimit(), expressionAnalyzer, expressionAnalysisContext, normalizer, coordinatorTxnCtx), RelationAnalyzer.longSymbolOrNull(node.getOffset(), expressionAnalyzer, expressionAnalysisContext, normalizer, coordinatorTxnCtx));
        statementContext.endRelation();
        return relation;
    }

    @Nullable
    private static Symbol longSymbolOrNull(Optional<Expression> optExpression, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext, EvaluatingNormalizer normalizer, CoordinatorTxnCtx coordinatorTxnCtx) {
        if (optExpression.isPresent()) {
            Symbol symbol = expressionAnalyzer.convert(optExpression.get(), expressionAnalysisContext);
            return normalizer.normalize(symbol.cast(DataTypes.LONG, new CastMode[0]), coordinatorTxnCtx);
        }
        return null;
    }

    @Nullable
    private static OrderBy analyzeOrderBy(SelectAnalysis selectAnalysis, List<SortItem> orderBy, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext, boolean hasAggregatesOrGrouping, boolean isDistinct) {
        ExpressionAnalyzer selectListExpressionAnalyzer = expressionAnalyzer.referenceSelect(selectAnalysis);
        return OrderyByAnalyzer.analyzeSortItems(orderBy, sortKey -> {
            Symbol symbol = RelationAnalyzer.symbolFromSelectOutputReferenceOrExpression(sortKey, selectAnalysis, "ORDER BY", selectListExpressionAnalyzer, expressionAnalysisContext);
            SemanticSortValidator.validate(symbol);
            if (hasAggregatesOrGrouping) {
                OrderByWithAggregationValidator.validate(symbol, selectAnalysis.outputSymbols(), isDistinct);
            }
            return symbol;
        });
    }

    private List<Symbol> analyzeGroupBy(SelectAnalysis selectAnalysis, List<Expression> groupBy, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext, boolean isGroupByAll) {
        ArrayList<Symbol> groupBySymbols = new ArrayList<Symbol>(groupBy.size());
        if (groupBy.isEmpty() && isGroupByAll) {
            for (Symbol symbol : selectAnalysis.outputSymbols()) {
                if (symbol.hasFunctionType(FunctionType.AGGREGATE) || symbol.hasFunctionType(FunctionType.TABLE)) continue;
                GroupBySymbolValidator.validate(symbol);
                groupBySymbols.add(symbol);
            }
        } else {
            for (Expression expression : groupBy) {
                Symbol symbol = RelationAnalyzer.symbolFromExpressionFallbackOnSelectOutput(expression, selectAnalysis, "GROUP BY", expressionAnalyzer, expressionAnalysisContext);
                GroupBySymbolValidator.validate(symbol);
                groupBySymbols.add(symbol);
            }
        }
        return groupBySymbols;
    }

    @Nullable
    private Symbol analyzeHaving(Optional<Expression> having, @Nullable List<Symbol> groupBy, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        if (having.isPresent()) {
            if (!expressionAnalysisContext.hasAggregates() && (groupBy == null || groupBy.isEmpty())) {
                throw new IllegalArgumentException("HAVING clause can only be used in GROUP BY or global aggregate queries");
            }
            Symbol symbol = expressionAnalyzer.convert(having.get(), expressionAnalysisContext);
            HavingSymbolValidator.validate(symbol, groupBy);
            return symbol;
        }
        return null;
    }

    private static Symbol symbolFromSelectOutputReferenceOrExpression(Expression expression, SelectAnalysis selectAnalysis, String clause, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        int ord = -1;
        if (expression instanceof IntegerLiteral) {
            IntegerLiteral intLiteral = (IntegerLiteral)expression;
            ord = intLiteral.getValue();
        } else if (expression instanceof LongLiteral) {
            LongLiteral longLiteral = (LongLiteral)expression;
            try {
                ord = DataTypes.INTEGER.sanitizeValue(longLiteral.getValue());
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use %s in %s clause", longLiteral, clause));
            }
        }
        if (ord > -1) {
            return RelationAnalyzer.ordinalOutputReference(selectAnalysis.outputSymbols(), ord, clause);
        }
        return expressionAnalyzer.convert(expression, expressionAnalysisContext);
    }

    @Nullable
    private static Symbol tryGetFromSelectList(QualifiedNameReference expression, SelectAnalysis selectAnalysis) {
        List parts = expression.getName().getParts();
        if (parts.size() == 1) {
            return SelectListFieldProvider.getOneOrAmbiguous(selectAnalysis.outputMultiMap(), (String)Iterables.getOnlyElement((Iterable)parts));
        }
        return null;
    }

    private static Symbol symbolFromExpressionFallbackOnSelectOutput(Expression expression, SelectAnalysis selectAnalysis, String clause, ExpressionAnalyzer expressionAnalyzer, ExpressionAnalysisContext expressionAnalysisContext) {
        try {
            Symbol symbol = expressionAnalyzer.convert(expression, expressionAnalysisContext);
            if (symbol instanceof Literal) {
                return RelationAnalyzer.getByPosition(selectAnalysis.outputSymbols(), (Literal)symbol, clause);
            }
            return symbol;
        }
        catch (ColumnUnknownException e) {
            QualifiedNameReference qnr;
            Symbol symbol;
            if (expression instanceof QualifiedNameReference && (symbol = RelationAnalyzer.tryGetFromSelectList(qnr = (QualifiedNameReference)expression, selectAnalysis)) != null) {
                return symbol;
            }
            throw e;
        }
    }

    private static Symbol getByPosition(List<Symbol> outputSymbols, Literal<?> ordinal, String clause) {
        Integer ord;
        if (ordinal.valueType().equals(DataTypes.UNDEFINED)) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use %s in %s clause", ordinal, clause));
        }
        try {
            ord = DataTypes.INTEGER.sanitizeValue(ordinal.value());
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Cannot use %s in %s clause", ordinal, clause));
        }
        if (ord == null) {
            return ordinal;
        }
        return RelationAnalyzer.ordinalOutputReference(outputSymbols, ord, clause);
    }

    private static Symbol ordinalOutputReference(List<Symbol> outputSymbols, int ordinal, String clauseName) {
        int idx = ordinal - 1;
        if (idx < 0) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s position %s is not in select list", clauseName, idx + 1));
        }
        try {
            return outputSymbols.get(idx);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s position %s is not in select list", clauseName, idx + 1));
        }
    }

    protected AnalyzedRelation visitAliasedRelation(AliasedRelation node, StatementAnalysisContext context) {
        TableFunctionRelation tableFunctionRelation;
        context.startRelation(true);
        AnalyzedRelation childRelation = (AnalyzedRelation)node.getRelation().accept((AstVisitor)this, (Object)context);
        List<String> columnAliases = node.getColumnNames();
        if (node.getColumnNames().isEmpty() && childRelation instanceof TableFunctionRelation && !Objects.equals((tableFunctionRelation = (TableFunctionRelation)childRelation).function().signature(), ValuesFunction.SIGNATURE) && tableFunctionRelation.outputs().size() == 1) {
            columnAliases = List.of(node.getAlias());
        }
        AliasedAnalyzedRelation aliasedRelation = new AliasedAnalyzedRelation(childRelation, new RelationName(null, node.getAlias()), columnAliases);
        context.endRelation();
        context.currentRelationContext().addSourceRelation(aliasedRelation);
        return aliasedRelation;
    }

    public AnalyzedRelation visitWithQuery(WithQuery node, StatementAnalysisContext context) {
        AnalyzedRelation childRelation = (AnalyzedRelation)node.query().accept((AstVisitor)this, (Object)context);
        AliasedAnalyzedRelation aliasedRelation = new AliasedAnalyzedRelation(childRelation, new RelationName(null, node.name()), node.columnNames());
        context.currentRelationContext().addSourceRelation(aliasedRelation);
        return aliasedRelation;
    }

    protected AnalyzedRelation visitTable(Table<?> node, StatementAnalysisContext context) {
        AnalyzedRelation relation;
        QualifiedName tableQualifiedName = node.getName();
        SearchPath searchPath = context.sessionSettings().searchPath();
        RelationAnalysisContext relationContext = context.currentRelationContext();
        AnalyzedRelation withQuery = relationContext.parentSources().getAncestor(RelationName.of(tableQualifiedName, null));
        if (withQuery != null) {
            relation = withQuery;
        } else {
            Object relationInfo;
            Object t = relationInfo = this.nodeCtx.schemas().findRelation(tableQualifiedName, context.currentOperation(), context.sessionSettings().sessionUser(), searchPath);
            Objects.requireNonNull(t);
            Object t2 = t;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DocTableInfo.class, ForeignTable.class, TableInfo.class, ViewInfo.class}, t2, n)) {
                case 0: {
                    DocTableInfo docTable = (DocTableInfo)t2;
                    relation = new DocTableRelation(docTable);
                    break;
                }
                case 1: {
                    ForeignTable table = (ForeignTable)t2;
                    relation = new ForeignTableRelation(table);
                    break;
                }
                case 2: {
                    TableInfo table = (TableInfo)t2;
                    relation = new TableRelation(table);
                    break;
                }
                case 3: {
                    ViewInfo viewInfo = (ViewInfo)t2;
                    Statement viewQuery = SqlParser.createStatement((String)viewInfo.definition());
                    CoordinatorSessionSettings viewSessionSettings = new CoordinatorSessionSettings(context.sessionSettings().authenticatedUser(), context.sessionSettings().sessionUser(), viewInfo.searchPath(), context.sessionSettings().hashJoinsEnabled(), context.sessionSettings().excludedOptimizerRules(), viewInfo.errorOnUnknownObjectKey(), context.sessionSettings().memoryLimitInBytes());
                    AnalyzedRelation resolvedView = context.withSessionSettings(viewSessionSettings, newContext -> (AnalyzedRelation)viewQuery.accept((AstVisitor)this, newContext));
                    Role owner = this.nodeCtx.roles().findRole(viewInfo.owner());
                    if (owner == null) {
                        throw new UnauthorizedException("Owner \"" + String.valueOf(owner) + "\" of the view \"" + viewInfo.owner() + "\" not found");
                    }
                    relation = new AnalyzedView(viewInfo.ident(), owner, resolvedView);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected relationInfo: " + String.valueOf(relationInfo));
                }
            }
        }
        relationContext.addSourceRelation(relation);
        return relation;
    }

    public AnalyzedRelation visitTableFunction(TableFunction node, StatementAnalysisContext statementContext) {
        RelationAnalysisContext context = statementContext.currentRelationContext();
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(statementContext.transactionContext(), this.nodeCtx, statementContext.paramTyeHints(), FieldProvider.UNSUPPORTED, null);
        ExpressionAnalysisContext expressionContext = context.expressionAnalysisContext();
        boolean allowEagerNormalizeOriginalValue = expressionContext.isEagerNormalizationAllowed();
        expressionContext.allowEagerNormalize(false);
        Symbol symbol = expressionAnalyzer.convert((Expression)node.functionCall(), expressionContext);
        expressionContext.allowEagerNormalize(allowEagerNormalizeOriginalValue);
        if (!(symbol instanceof io.crate.expression.symbol.Function)) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Symbol '%s' is not supported in FROM clause", node.name()));
        }
        io.crate.expression.symbol.Function function = (io.crate.expression.symbol.Function)symbol;
        FunctionImplementation functionImplementation = this.nodeCtx.functions().getQualified(function);
        assert (functionImplementation != null) : "Function implementation not found using full qualified lookup";
        TableFunctionImplementation<?> tableFunction = TableFunctionFactory.from(functionImplementation);
        TableFunctionRelation tableRelation = new TableFunctionRelation(tableFunction, function);
        context.addSourceRelation(tableRelation);
        return tableRelation;
    }

    protected AnalyzedRelation visitTableSubquery(TableSubquery node, StatementAnalysisContext context) {
        if (!context.currentRelationContext().isAliasedRelation()) {
            throw new UnsupportedOperationException("subquery in FROM clause must have an alias");
        }
        return (AnalyzedRelation)super.visitTableSubquery(node, (Object)context);
    }

    public AnalyzedRelation visitValues(Values values, StatementAnalysisContext context) {
        ExpressionAnalyzer expressionAnalyzer = new ExpressionAnalyzer(context.transactionContext(), this.nodeCtx, context.paramTyeHints(), FieldProvider.UNSUPPORTED, new SubqueryAnalyzer(this, context));
        ExpressionAnalysisContext expressionAnalysisContext = new ExpressionAnalysisContext(context.sessionSettings());
        expressionAnalysisContext.allowEagerNormalize(false);
        Function<Expression, Symbol> expressionToSymbol = e -> expressionAnalyzer.convert((Expression)e, expressionAnalysisContext);
        List rows = values.rows();
        assert (!rows.isEmpty()) : "Parser grammar enforces at least 1 row";
        ValuesList firstRow = (ValuesList)rows.get(0);
        int numColumns = firstRow.values().size();
        ArrayList columns = new ArrayList();
        ArrayList<UndefinedType> targetTypes = new ArrayList<UndefinedType>(numColumns);
        List<? extends Symbol> parentOutputColumns = context.parentOutputColumns();
        for (int c = 0; c < numColumns; ++c) {
            DataType targetType;
            ArrayList<Symbol> columnValues = new ArrayList<Symbol>();
            boolean usePrecedence = true;
            if (parentOutputColumns.size() > c) {
                targetType = parentOutputColumns.get(c).valueType();
                usePrecedence = false;
            } else {
                targetType = DataTypes.UNDEFINED;
            }
            for (int r = 0; r < rows.size(); ++r) {
                List row = ((ValuesList)rows.get(r)).values();
                if (row.size() != numColumns) {
                    throw new IllegalArgumentException("VALUES lists must all be the same length. Found row with " + numColumns + " items and another with " + columns.size() + " items");
                }
                Symbol cell = expressionToSymbol.apply((Expression)row.get(c));
                columnValues.add(cell);
                DataType<Object> cellType = cell.valueType();
                if (r > 0 && !cellType.isConvertableTo(targetType, false) && ArrayType.unnest(targetType).id() != DataTypes.UNDEFINED.id()) {
                    throw new IllegalArgumentException("The types of the columns within VALUES lists must match. Found `" + String.valueOf(targetType) + "` and `" + String.valueOf(cellType) + "` at position: " + c);
                }
                if ((!usePrecedence || !cellType.precedes(targetType)) && targetType != DataTypes.UNDEFINED) continue;
                targetType = cellType;
            }
            targetTypes.add((UndefinedType)targetType);
            columns.add(columnValues);
        }
        EvaluatingNormalizer normalizer = EvaluatingNormalizer.functionOnlyNormalizer(this.nodeCtx, f -> f.signature().isDeterministic());
        ArrayList<Symbol> arrays = new ArrayList<Symbol>(columns.size());
        for (int c = 0; c < numColumns; ++c) {
            DataType targetType = (DataType)targetTypes.get(c);
            ArrayType arrayType = new ArrayType(targetType);
            List columnValues = Lists.map((Collection)((Collection)columns.get(c)), s -> normalizer.normalize(s.cast(targetType, new CastMode[0]), context.transactionContext()));
            arrays.add(new io.crate.expression.symbol.Function(ArrayFunction.SIGNATURE, columnValues, arrayType));
        }
        FunctionImplementation implementation = this.nodeCtx.functions().getQualified(ValuesFunction.SIGNATURE, Symbols.typeView(arrays), RowType.EMPTY);
        io.crate.expression.symbol.Function function = new io.crate.expression.symbol.Function(implementation.signature(), arrays, RowType.EMPTY);
        TableFunctionImplementation<?> tableFunc = TableFunctionFactory.from(implementation);
        TableFunctionRelation relation = new TableFunctionRelation(tableFunc, function);
        context.startRelation();
        context.currentRelationContext().addSourceRelation(relation);
        context.endRelation();
        return relation;
    }
}

